% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindMaxHomoOptimalPartitions.R
\name{FindMaxHomoOptimalPartitions}
\alias{FindMaxHomoOptimalPartitions}
\title{FindMaxHomoOptimalPartitions}
\usage{
FindMaxHomoOptimalPartitions(
  DataT,
  gamma = 0.05,
  insigThs = 1e-08,
  alpha = 0.05,
  minInvs = 99,
  polyDegree = 1,
  expFlag = FALSE,
  messageFlag = FALSE
)
}
\arguments{
\item{DataT}{contains a multiresolution dataset s.t.
\code{DataT$X[i,d]} is a value of feature \code{d} of individual \code{i},
\code{DataT$Y[i]} is value of target variable of individual \code{i} that we want to fit \code{DataT$Y ~ DataT$X} in linear model, and
\code{clsLayer[i,j]} is a cluster ID of individual \code{i} at layer \code{j}; \code{clsLayer[i,1]} is the first layer that everyone typically belongs to a single cluster.}

\item{gamma}{is a threshold to ...}

\item{insigThs}{is a threshold to determine whether a magnitude of a feature coefficient is enough so that the feature is designated as a selected feature.}

\item{alpha}{is a significance level to determine whether a magnitude of a feature coefficient is enough so that the feature is designated as a selected feature.}

\item{minInvs}{is a minimum number of individuals for a cluster to be considered for inferring eta(C)cv, otherwise, eta(C)cv=0.}

\item{polyDegree}{is a degree of polynomial function that is used to fit the data.
If it is greater than 1, the polynomial formula is used in \code{lm()} instead of \code{"y=."}.}

\item{expFlag}{is an exponential flag to control the formula for data fitting.
If it is true, then the exp() formula is used in \code{lm()} instead of \code{"y=."}.}

\item{messageFlag}{is a flag. If it is true, the function shows the text regarding the progress of computing.}
}
\value{
This function returns \code{Copt}, \code{models}, \code{nNodes},  \code{invOptCls}, and \code{minR2cv}.

\item{ \code{Copt[p,1]} }{ is equal to \code{k} implies a cluster that is a pth member of the maximal homogeneous partition is at kth layer and the cluster name in kth layer is \code{Copt[p,2]} }
\item{ \code{Copt[p,3]} }{ is "Model Information Reduction Ratio" \code{I({C},H0,Hlin)} of \code{p}th member of the maximal homogeneous partition: positive means the linear model is better than the null model.}
\item{ \code{Copt[p,4]} }{  is the squared correlation between predicted and real Y in CV step ( eta(C)cv ) of pth member of the maximal homogeneous partition. The greater \code{Copt[p,4]}, the higher homogeneous degree of this cluster.}
\item{ \code{ models[[k]][[j]]$clustInfoRecRatio} }{ is the "Cluster Information Reduction Ratio"  \code{I(Cj,Cjchildren,H)} between the \code{j}th cluster in \code{k}th layer
and its children clusters in \code{(k+1)}th layer: positive means current cluster is better than its children clusters.
Hence, we should keep this cluster at the member of maximal homogeneous partition instead of its children.}
\item{ \code{models[[j]][[k]]} }{ is a linear model of a cluster ID \code{k} at the layer \code{j}.
The \code{models[[j]][[k]]$selFeatureSet} represents a set of selected-feature indices of the model where the feature index 1 is the intercept,
and the feature index \code{d} is the (d-1)th variable \code{DataT$X[,d-1]}. }
\item{ \code{invOptCls[i,1]} }{ is the layer of optimal cluster of individual \code{i}. The optimal cluster of \code{i} is \code{invOptCls[i,2]}. }
\item{minR2cv}{ is the value of eta(C)cv from the cluster that has the lowest eta(C)cv.  }
\item{DataT}{is an updated \code{DataT} with the helper variables for plotting and printing results.}
}
\description{
FindMaxHomoOptimalPartitions is a main function for inferring optimal homogeneous clusters from a multiresolution dataset \code{DataT}.
}
\examples{
# Running FindMaxHomoOptimalPartitions using simulation data
DataT<-SimpleSimulation(100,type=1)
obj<-FindMaxHomoOptimalPartitions(DataT,gamma=0.05)

}
