% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_data.R
\docType{data}
\name{Albacore_TwoFleet}
\alias{Albacore_TwoFleet}
\title{A two-fleet Albacore operating model}
\format{An object of class \linkS4class{MOM}.}
\usage{
Albacore_TwoFleet
}
\description{
A generic operating model for an albacore stock with two fishing fleets. The first fleet has
dome-shaped selectivity (similar to a baitboat fleet) while the second fleet exhibits logistic
selectivity (such as a longline fleet). With the \code{CatchFrac} slot, we generate a 30%-70% catch
ratio between the baitboat-longline fleets in the most recent historical year.
}
\examples{
\donttest{
## Plot historical effort and selectivity between the 2 fleets
plot(Albacore_TwoFleet)

## Generate data (e.g., catch, length comps) from the fleets
Hist <- multiMSE(Albacore_TwoFleet, Hist = TRUE)
DataList <- Hist$Data

# Fleet one
summary(DataList[[1]][[1]])

# Fleet two
summary(DataList[[1]][[2]])
}
}
\keyword{datasets}
