% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_definitions.R
\docType{class}
\name{Fleet-class}
\alias{Fleet-class}
\title{Class \code{'Fleet'}}
\description{
The component of the operating model that controls fishing dynamics
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the Fleet object. Single value. Character string.}

\item{\code{Name}}{Name of the Fleet object. Single value. Character string.}

\item{\code{nyears}}{The number of years for the historical 'spool-up' simulation.
Single value. Positive integer}

\item{\code{CurrentYr}}{The current calendar year (final year) of the historical
simulations (eg 2011). Single value. Positive integer}

\item{\code{EffYears}}{Years representing join-points (vertices) of time-varying
effort. Vector. Non-negative real numbers}

\item{\code{EffLower}}{Lower bound on relative effort corresponding to EffYears.
Vector. Non-negative real numbers}

\item{\code{EffUpper}}{Upper bound on relative effort corresponding to EffYears.
Vector. Non-negative real numbers}

\item{\code{Esd}}{Additional inter-annual variability in fishing mortality rate.
Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{qinc}}{Average percentage change in fishing efficiency (applicable only
to forward projection and input controls). Uniform distribution lower and upper
bounds. Non-negative real numbers}

\item{\code{qcv}}{Inter-annual variability in fishing efficiency (applicable only to
forward projection and input controls). Uniform distribution lower and upper
bounds. Non-negative real numbers}

\item{\code{L5}}{Shortest length corresponding to 5 percent vulnerability. Uniform
distribution lower and upper bounds. Positive real numbers}

\item{\code{LFS}}{Shortest length that is fully vulnerable to fishing. Uniform
distribution lower and upper bounds. Positive real numbers}

\item{\code{Vmaxlen}}{The vulnerability of fish at \code{Stock@Linf}. Uniform
distribution lower and upper bounds. Fraction}

\item{\code{isRel}}{Selectivity parameters in units of size-of-maturity (or absolute
eg cm). Single value. Boolean}

\item{\code{LR5}}{Shortest length corresponding at 5 percent retention. Uniform
distribution lower and upper bounds. Non-negative real numbers}

\item{\code{LFR}}{Shortest length that is fully retained. Uniform distribution lower
and upper bounds. Non-negative real numbers}

\item{\code{Rmaxlen}}{The retention of fish at \code{Stock@Linf}. Uniform
distribution lower and upper bounds. Non-negative real numbers}

\item{\code{DR}}{Discard rate - the fraction of caught fish that are discarded.
Uniform distribution lower and upper bounds. Fraction}

\item{\code{Spat_targ}}{Distribution of fishing in relation to spatial biomass:
fishing distribution is proportional to B^Spat_targ. Uniform distribution lower
and upper bounds. Real numbers}

\item{\code{MPA}}{Is Area 1 currently closed (TRUE) or open (FALSE)? Defaults to
FALSE}

\item{\code{Misc}}{Miscellaneous list for bio-economic parameters}
}}

\section{Creating Object}{

Objects can be created by calls of the form \code{new('Fleet')}
}

\examples{
showClass('Fleet')

}
\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
