% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMSE.R
\name{SimulateMOM}
\alias{SimulateMOM}
\alias{ProjectMOM}
\alias{multiMSE}
\title{Run a multi-fleet multi-stock Management Strategy Evaluation}
\usage{
SimulateMOM(MOM = MSEtool::Albacore_TwoFleet, parallel = TRUE, silent = FALSE)

ProjectMOM(
  multiHist = NULL,
  MPs = NA,
  parallel = FALSE,
  silent = FALSE,
  checkMPs = TRUE,
  dropHist = FALSE,
  extended = FALSE
)

multiMSE(
  MOM = MSEtool::Albacore_TwoFleet,
  MPs = list(list(c("AvC", "DCAC"), c("FMSYref", "curE"))),
  Hist = FALSE,
  silent = FALSE,
  parallel = TRUE,
  checkMPs = TRUE,
  dropHist = TRUE,
  extended = FALSE
)
}
\arguments{
\item{MOM}{A multi-fleet multi-stock operating model (class 'MOM')}

\item{parallel}{Logical or a named list. Should MPs be run using parallel processing?  See Details for more information.}

\item{silent}{Should messages be printed out to the console?}

\item{multiHist}{An Historical Simulation object (class \code{multiHist})}

\item{MPs}{A matrix of methods (nstock x nfleet) (character string) of class MP}

\item{checkMPs}{Logical. Check if the specified MPs exist and can be run on \code{SimulatedData}?}

\item{dropHist}{Logical. Drop the (very large) \code{multiHist} object from the returned \code{MMSE} object?
The \code{multiHist} object can be (re-)created using \code{SimulateMOM} or kept in \code{MMSE@multiHist} if
\code{dropHist=FALSE}}

\item{extended}{Logical. Return extended projection results?
if TRUE, \code{MMSE@Misc$extended} is a named list with extended data
(including historical and projected abundance by area).}

\item{Hist}{Should model stop after historical simulations? Returns a list
containing all historical data}
}
\value{
Functions return objects of class \code{MMSE} and \code{multiHist}
#' \itemize{
\item SimulateMOM - An object of class \code{multiHist}
\item ProjectMOM - An object of class \code{MMSE}
\item multiMSE - An object of class \code{MMSE}
}
}
\description{
Functions for running a multi-stock and/or multi-fleet Management
Strategy Evaluation (closed-loop simulation) for a specified operating model
}
\details{
\subsection{Running MPs in parallel}{

For most MPs, running in parallel can actually lead to an increase in computation time, due to the overhead in sending the
information over to the cores. Consequently, by default the MPs will not be run in parallel if \code{parallel=TRUE}
(although other internal code will be run in parallel mode).

To run MPs in parallel, specify a named list with the name of the MP(s) assigned as TRUE. For example,\verb{parallel=list(AvC=TRUE})
will run the \code{AvC} MP in parallel mode.
}
}
\section{Functions}{
\itemize{
\item \code{SimulateMOM()}: Simulate historical dynamics for multi-OM

\item \code{ProjectMOM()}: Run Forward Projections for a \code{MOM} object

\item \code{multiMSE()}: Run a multi-stock, multi-fleet MSE

}}
\author{
T. Carruthers and A. Hordyk
}
