% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.R
\name{AIC}
\alias{AIC}
\title{Compute Akaike information criterion (AIC).}
\usage{
AIC(fit)
}
\arguments{
\item{fit}{Fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT} created with \code{\link{fit.bayes}}.}
}
\value{
AIC value.
}
\description{
Compute Akaike information criterion (AIC).
}
\details{
If a matrix of MCMC posterior draws estimates is given, the AIC on the posterior mean is calculated.
}
\examples{
# load data
data("sp500")
sp500 = sp500[1:1000]

# create model specification
spec = MSGARCH::create.spec() 

# fit the model by MLE                                                         
fit = MSGARCH::fit.mle(spec = spec, y = sp500, ctr = list(do.init = FALSE))

# compute AIC
AIC = MSGARCH::AIC(fit)
}
\references{
Akaike, H. (1974). A New Look at the Statistical Model Identification. \emph{IEEE Transactions on Automatic Control}, 19, pp. 716-723.
}

