% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simuMSAR_cpp}
\alias{simuMSAR_cpp}
\title{Simulate Markov-switching autoregressive process}
\usage{
simuMSAR_cpp(mdl_h0, burnin = 100L)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item n: Length of series.
  \item k: Number of regimes.
  \item mu: A (\code{k x 1}) vector with mean of process in each regime.
  \item sigma: A (\code{k x 1}) vector with standard deviation of process in each regime.
  \item phi: Vector of autoregressive coefficients.
  \item P: A (\code{k x k}) transition matrix (columns must sum to one).
  \item eps: An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated Markov-switching autoregressive process and its DGP properties.
}
\description{
This function simulates a Markov-switching autoregressive process.
}
\keyword{internal}
