% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCV.R
\name{getCV}
\alias{getCV}
\title{Calculate coefficient of variation (CV)}
\usage{
getCV(x, Group = NULL)
}
\arguments{
\item{x}{sample ion intensity matrix, row sample, column feature.}

\item{Group}{sample group information}
}
\value{
a dataframe with mean values and cv
}
\description{
Calculate coefficient of variation (CV), also
known as relative standard deviation (RSD) among different sample groups
}
\examples{
dat <- matrix(runif(2*300), ncol = 2, nrow = 300)
myGroup <- rep_len(LETTERS[1:2], 300)
ret <- getCV(dat, Group = myGroup)
}
