% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muac.R
\name{indivmuaczs}
\alias{indivmuaczs}
\title{Generate MUAC z scores for age for single individuals given their age, sex and muac values.}
\usage{
indivmuaczs(age = 60, sex = 1, muac = 10, verbose = FALSE)
}
\arguments{
\item{age}{a numeric value (in months) between 60 and 300.}

\item{sex}{preferably numeric (1 = Male, 2 = Female). Strings can also be used.}

\item{muac}{a numeric value in cm between 5 and 50.}

\item{verbose}{Is FALSE by default. If set to TRUE, 'notes' will be printed on the console about the nature, range of variables allowed and number of records processed.}
}
\value{
A DataFrame with MUAC z scores.
}
\description{
Generates MUAC z Scores for an individual subject by entering their age (in months), sex and muac (in cm) directly.
This is useful for children and adolescents aged 5 to 19 years to assess their nutritional and health status, and  define risk of adverse health events.
}
\examples{
## Provide values for one individual for age, sex and muac
test1 <- indivmuaczs(age=62, sex=1, muac=20)
test2 <- indivmuaczs(age=65, sex=2, muac=12.5)
test3 <- indivmuaczs(age=70, sex="Female", muac=15.8)
test4 <- indivmuaczs(age=92, sex="Male", muac=5.3)
# test5 <- indivmuaczs(age=92, sex="Male", muac=5.3, verbose=TRUE) # Prints NOTES

}
\references{
Mramba L., Ngari M., Mwangome M., Muchai L., Bauni E., Walker A.S., Gibb D.M., Fegan G. and Berkley J.A. (2017)
\emph{A growth reference for mid upper arm circumference for age among school age children and adolescents, and validation for mortality: growth curve construction and longitudinal cohort study}
BMJ 2017;358:j3423 <doi:10.1136/bmj.j3423> <https://www.bmj.com/content/358/bmj.j3423>

<https://www.who.int/childgrowth/standards/Technical_report.pdf>

<https://www.who.int/childgrowth/standards/ac_for_age/en/>
}
\seealso{
\code{\link{muaczs}}  and \code{\link{plotref}}.
}
