NormTest <- function(Data, Sign = 0.05) {
  # Executa teste para verificar a normalidade dos dados baseado
  # no teste de coeficiente de assimetria
  # Desenvolvida por Paulo Cesar Ossani em 22/06/2013
  # Ver Livro Daniel Furtado pg. 115 e Rencher pg. 114
  
  # Entrada
  # Data - Dados a serem analisados
  # Sign - Grau de significancia do teste (default 5%)
  
  
  # Retorna:
  # Statistic   - Valor Chi-quadrado observado, ou seja, a estatistica do teste.
  # ChiQuadrado - Valor Chi-quadrado calculado.
  # GL      - Grau de liberdade.
  # p.Value - Valor p.
  
  if (!is.data.frame(Data) && !is.matrix(Data)) 
     stop("'Data' input is incorrect, it should be of type data frame or matrix. Verify!")
  
  if (!is.numeric(Sign)) 
     stop("'Sign' input is incorrect, it should be numeric with values between 0 and 1. Verify!")
  
  if (Sign<=0 || Sign>1) 
     stop("'Sign' input is incorrect, it should be numeric with values between 0 and 1. Verify!")
  
  n <- ncol(Data)*nrow(Data) # numero de elementos amostrais
  
  p <- ncol(Data)  # numero de parametros
  
  gl =  p*(p+1)*(p+2)/6 # grau de liberdade
  
  Media = as.vector(apply(Data,2,mean))  # Data medias das colunas
  
  G     = t(t(Data)-Media)%*%solve(cov(Data))%*%(t(Data)-Media)
  
  B1p   = sum((diag(G))^3/n^2)
  
  Chi.Quad.Observado <- n*B1p/6 # Estatistica do Teste
  
  qt = qchisq(1-Sign,gl,ncp=0) # Valor Qui-quadrado calculado
  
  pVal <- pchisq(Chi.Quad.Observado,gl,ncp=0, lower.tail = F)
  
#  cat(paste("Grau de liberdade observado:", round(gl,7)),"\n")

#  cat(paste("Valor da estatistica do teste Qui-quadrado (Chiq1):", round(Chi.Quad.Observado,7)),"\n")
  
#  cat(paste("Valor Qui-quadrado calculado (Chiq2) com", Sign*100,"% de significancia:", round(qt,7)),"\n")
  
#  if (Chi.Quad.Observado<=qt) cat("Como Chiq1 <= Chiq2, VERIFICA-SE a normalidade dos dados.\n")
  
#  if (Chi.Quad.Observado>qt) cat("Como Chiq1 > Chiq2, NAO VERIFICA-SE a normalidade dos dados.\n")
  
#  cat("Valor-p:", pVal)
  
  Lista <- list(Statistic = Chi.Quad.Observado, ChiQuadrado = qt, GL = gl, p.Value = pVal)
  
  returnValue(Lista)
  
}