% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFrame.R
\name{ModelFrame}
\alias{ModelFrame}
\alias{ModelFrame.formula}
\alias{ModelFrame.matrix}
\title{ModelFrame Class}
\usage{
ModelFrame(x, ...)

\method{ModelFrame}{formula}(x, data, weights = NULL, strata = NULL,
  na.action = NULL, ...)

\method{ModelFrame}{matrix}(x, y, weights = NULL, strata = NULL,
  na.action = NULL, ...)
}
\arguments{
\item{x}{model \code{\link{formula}} or matrix of predictor variables.}

\item{...}{arguments passed to other methods.}

\item{data}{data frame or an object that can be converted to one.}

\item{weights}{vector of case weights.}

\item{strata}{vector of stratification levels.}

\item{na.action}{action to take if cases contain missing values.  The default
is first any \code{na.action} attribute of \code{data}, second a
\code{na.action} setting of \code{\link{options}}, and third
\code{\link{na.fail}} if unset.}

\item{y}{response variable.}
}
\description{
Class for storing a data frame, formula, and optionally weights for fitting
MLModels.
}
\examples{
mf <- ModelFrame(ncases / (ncases + ncontrols) ~ agegp + tobgp + alcgp,
                 data = esoph, weights = ncases + ncontrols)
gbmfit <- fit(mf, model = GBMModel)
varimp(gbmfit)

}
\seealso{
\code{\link{formula}}, \code{\link{na.fail}}, \code{\link{na.omit}},
\code{\link{na.pass}}
}
