% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_SVMModel.R
\name{SVMModel}
\alias{SVMModel}
\alias{SVMANOVAModel}
\alias{SVMBesselModel}
\alias{SVMLaplaceModel}
\alias{SVMLinearModel}
\alias{SVMPolyModel}
\alias{SVMRadialModel}
\alias{SVMSplineModel}
\alias{SVMTanhModel}
\title{Support Vector Machine Models}
\usage{
SVMModel(scaled = TRUE, type = NULL, kernel = c("rbfdot", "polydot",
  "vanilladot", "tanhdot", "laplacedot", "besseldot", "anovadot",
  "splinedot"), kpar = "automatic", C = 1, nu = 0.2, epsilon = 0.1,
  cache = 40, tol = 0.001, shrinking = TRUE)

SVMANOVAModel(sigma = 1, degree = 1, ...)

SVMBesselModel(sigma = 1, order = 1, degree = 1, ...)

SVMLaplaceModel(sigma = NULL, ...)

SVMLinearModel(...)

SVMPolyModel(degree = 1, scale = 1, offset = 1, ...)

SVMRadialModel(sigma = NULL, ...)

SVMSplineModel(...)

SVMTanhModel(scale = 1, offset = 1, ...)
}
\arguments{
\item{scaled}{logical vector indicating the variables to be scaled.}

\item{type}{type of support vector machine.}

\item{kernel}{kernel function used in training and predicting.}

\item{kpar}{list of hyper-parameters (kernel parameters).}

\item{C}{cost of constraints violation defined as the regularization term in
the Lagrange formulation.}

\item{nu}{parameter needed for nu-svc, one-svc, and nu-svr.}

\item{epsilon}{parameter in the insensitive-loss function used for eps-svr,
nu-svr and eps-bsvm.}

\item{cache}{cache memory in MB.}

\item{tol}{tolerance of termination criterion.}

\item{shrinking}{whether to use the shrinking-heuristics.}

\item{sigma}{inverse kernel width used by the ANOVA, Bessel, and Laplacian
kernels.}

\item{degree}{degree of the ANOVA, Bessel, and polynomial kernel functions.}

\item{...}{arguments to be passed to \code{SVMModel}.}

\item{order}{order of the Bessel function to be used as a kernel.}

\item{scale}{scaling parameter of the polynomial and hyperbolic tangent
kernels as a convenient way of normalizing patterns without the need to
modify the data itself.}

\item{offset}{offset used in polynomial and hyperbolic tangent kernels.}
}
\value{
MLModel class object.
}
\description{
Fits the well known C-svc, nu-svc, (classification) one-class-svc (novelty)
eps-svr, nu-svr (regression) formulations along with native multi-class
classification formulations and the bound-constraint SVM formulations.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}}
}

Arguments \code{kernel} and \code{kpar} are automatically set by the
kernel-specific constructor functions.
Default values for the \code{NULL} arguments and further model details can be
found in the source link below.
}
\examples{
library(MASS)

fit(medv ~ ., data = Boston, model = SVMRadialModel())

}
\seealso{
\code{\link[kernlab]{ksvm}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
