% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFrame.R
\name{ModelFrame}
\alias{ModelFrame}
\alias{ModelFrame.formula}
\alias{ModelFrame.matrix}
\title{ModelFrame Class}
\usage{
ModelFrame(x, ...)

\method{ModelFrame}{formula}(x, data, na.rm = TRUE, weights = NULL, strata = NULL, ...)

\method{ModelFrame}{matrix}(
  x,
  y = NULL,
  na.rm = TRUE,
  offsets = NULL,
  weights = NULL,
  strata = NULL,
  ...
)
}
\arguments{
\item{x}{model \code{\link{formula}} or \code{\link{matrix}} of predictor
variables.}

\item{...}{arguments passed to other methods.}

\item{data}{\link[=data.frame]{data frame} or an object that can be converted
to one.}

\item{na.rm}{logical indicating whether to remove cases with \code{NA} values
for any of the model variables.}

\item{weights}{vector of case weights [default: equal].}

\item{strata}{vector of values to use in conducting stratified
\link{resample} estimation of model performance [default: none].}

\item{y}{response variable.}

\item{offsets}{numeric vector, matrix, or data frame of values to be added
with a fixed coefficient of 1 to linear predictors in compatible regression
models.}
}
\value{
\code{ModelFrame} class object that inherits from \code{data.frame}.
}
\description{
Class for storing data, formulas, and other attributes for \pkg{MachineShop}
model fitting.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

mf <- ModelFrame(ncases / (ncases + ncontrols) ~ agegp + tobgp + alcgp,
                 data = esoph, weights = with(esoph, ncases + ncontrols))
gbm_fit <- fit(mf, model = GBMModel)
varimp(gbm_fit)
}

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}, \code{\link{response}},
\code{\link{SelectedInput}}
}
