% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSpecification.R
\name{ModelSpecification}
\alias{ModelSpecification}
\alias{ModelSpecification.default}
\alias{ModelSpecification.formula}
\alias{ModelSpecification.matrix}
\alias{ModelSpecification.ModelFrame}
\alias{ModelSpecification.recipe}
\title{Model Specification}
\usage{
ModelSpecification(...)

\method{ModelSpecification}{default}(
  input,
  model = NULL,
  control = MachineShop::settings("control"),
  metrics = NULL,
  cutoff = MachineShop::settings("cutoff"),
  stat = MachineShop::settings("stat.TrainingParams"),
  ...
)

\method{ModelSpecification}{formula}(formula, data, model, ...)

\method{ModelSpecification}{matrix}(x, y, model, ...)

\method{ModelSpecification}{ModelFrame}(input, model = NULL, ...)

\method{ModelSpecification}{recipe}(input, model = NULL, ...)
}
\arguments{
\item{...}{arguments passed from the generic function to its methods.  The
first argument of each \code{ModelSpecification} method is positional and,
as such, must be given first in calls to them.}

\item{input}{\link[=inputs]{input} object defining and containing the model
predictor and response variables.}

\item{model}{\link[=models]{model} function, function name, or object; or
another object that can be \link[=as.MLModel]{coerced} to a model.  The
argument can be omitted altogether in the case of
\link[=ModeledInput]{modeled inputs}.}

\item{control}{\link[=controls]{control} function, function name, or object
defining the resampling method to be employed.  Specification of a
resampling method results in the following characteristics.
\enumerate{
  \item Tuning of input and model objects is performed simultaneously over
    a global grid of their parameter values.
  \item The specification's \code{control} method and training parameters
    below override those of any included \code{TunedInput} or
    \code{TunedModel}.
  \item \code{ModeledInput}, \code{SelectedInput}, and \code{SelectedModel}
    objects are not allowed in the \code{input} or \code{model} arguments.
}
Alternatively, a value of \code{NULL} may be specified so that any package
input or model object is allowed, object-specific control structures and
training parameters are used for selection and tuning, and objects are
trained sequentially with nested resampling rather than simultaneously with
a global grid.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Model
selection is based on the first calculated metric.}

\item{cutoff}{argument passed to the \code{metrics} functions.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for model tuning.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}
}
\value{
\code{ModelSpecification} class object.
}
\description{
Specification of a relationship between response and predictor variables and
a model to define a relationship between them.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

modelspec <- ModelSpecification(
  sale_amount ~ ., data = ICHomes, model = GBMModel
)
fit(modelspec)
}

}
\seealso{
\code{\link{fit}}, \code{\link{resample}},
\code{\link{set_monitor}}, \code{\link{set_optim}}
}
