% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATT.R
\name{att}
\alias{att}
\title{Average Treatment Effect for the Treated (ATT)}
\usage{
att(obj, Y)
}
\arguments{
\item{obj}{MatchIt Object}

\item{Y}{Response Vector}
}
\value{
The ATT for \code{Y}
}
\description{
Calculate the ATT for a given MathIt object and a given response vector.
}
\examples{
\dontrun{
  library(MatchIt)
  data("lalonde")
  m.out  <- matchit(treat ~ educ + black, data = lalonde)
  att(obj = m.out, Y = lalonde$re78)
}

}

