% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{MeshesUnion}
\alias{MeshesUnion}
\title{Meshes union}
\usage{
MeshesUnion(meshes, clean = FALSE, normals = FALSE, numbersType = "double")
}
\arguments{
\item{meshes}{a list of two or more meshes, each being
either a \strong{rgl} mesh, or as a list with (at least) two fields:
\code{vertices} and \code{faces}; the \code{vertices}
matrix must have the \code{bigq} class if \code{numbersType="gmp"},
otherwise it must be numeric}

\item{clean}{Boolean, whether to clean the input meshes (merging duplicated
vertices, duplicated faces, removed isolated vertices) as well as the
output mesh}

\item{normals}{Boolean, whether to return the per-vertex normals of the
output mesh}

\item{numbersType}{the type of the numbers used in C++ for the
computations; must be one of \code{"double"}, \code{"lazyExact"}
(a type provided by CGAL for exact computations), or \code{"gmp"}
(exact computations with rational numbers); of course using
exact computations is slower but more accurate}
}
\value{
A triangle mesh given as a list with fields \code{vertices},
  \code{faces}, \code{edges}, \code{exteriorEdges}, \code{gmpvertices}
  if \code{numbersType="gmp"}, and \code{normals} if \code{normals=TRUE}.
}
\description{
Computes the union of the given meshes.
}
\examples{
library(MeshesOperations)
library(rgl)

# mesh one: a cube
mesh1 <- cube3d() # (from the rgl package)

# mesh two: another cube
mesh2 <- translate3d( # (from the rgl package)
  cube3d(), 1, 1, 1
)

# compute the union
umesh <- MeshesUnion(list(mesh1, mesh2))

# plot
rglumesh <- toRGL(umesh)
open3d(windowRect = c(50, 50, 562, 562))
shade3d(rglumesh, color = "red")
plotEdges(
  vertices = umesh[["vertices"]], edges = umesh[["exteriorEdges"]],
  edgesAsTubes = TRUE, verticesAsSpheres = TRUE
)
}
