% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateTPASR.R
\name{calculateTPASR}
\alias{calculateTPASR}
\title{Calcualte Triangle Peak Area Similarity Ratio (TPASR) (of a Chromatographic Peak)}
\usage{
calculateTPASR(peakData, pts)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}
}
\value{
The TPASR value (double)
}
\description{
Calculates the Triangle Peak Area Similarity Ratio (TPASR) of the integrated region of a chromatographic peak. The TPASR is found
by calculating the ratio of the difference between the area of a triangle formed by the apex and the two peak boundaries and the
integrated area of the peak over the area of the triangle.
}
\details{
This function repurposed from Zhang et al. For details, see Zhang, W., & Zhao, P. X. (2014). Quality evaluation of extracted
ion chromatograms and chromatographic peaks in liquid chromatography/mass spectrometry-based metabolomics data. BMC Bioinformatics,
15(Suppl 11), S5. https://doi.org/10.1186/1471-2105-15-S11-S5
}
\examples{
# Calculate TPASR for a peak
data(ex_pts)
data(ex_peakData)
tpasr <- calculateTPASR(peakData = ex_peakData, pts = ex_pts)

}
