% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metalonda.R
\name{metalonda}
\alias{metalonda}
\title{Metagenomic Longitudinal Differential Abundance Analysis for one feature}
\usage{
metalonda(Count, Time, Group, ID, n.perm = 500,
  fit.method = "nbinomial", points, text = 0, parall = FALSE,
  pvalue.threshold = 0.05, adjust.method = "BH", time.unit = "days",
  ylabel = "Normalized Count", col = c("blue", "firebrick"),
  prefix = "Test")
}
\arguments{
\item{Count}{matrix has the number of reads that mapped to each feature in each sample.}

\item{Time}{vector of the time label of each sample.}

\item{Group}{vector of the group label of each sample.}

\item{ID}{vector of the subject ID label of each sample.}

\item{n.perm}{number of permutations.}

\item{fit.method}{fitting method (nbinomial, lowess).}

\item{points}{points at which the prediction should happen.}

\item{text}{Feature's name.}

\item{parall}{boolean to indicate whether to use multicore.}

\item{pvalue.threshold}{p-value threshold cutoff for identifing significant time intervals.}

\item{adjust.method}{multiple testing correction method.}

\item{time.unit}{time unit used in the Time vector (hours, days, weeks, months, etc.)}

\item{ylabel}{text to be shown on the y-axis of all generated figures (default: "Normalized Count")}

\item{col}{two color to be used for the two groups (eg., c("red", "blue")).}

\item{prefix}{prefix to be used to create directory for the analysis results}
}
\value{
returns a list of the significant time intervals for the tested feature.
}
\description{
Find significant time intervals of the one feature
}
\examples{
data(metalonda_test_data)
n.sample = 5
n.timepoints = 10
n.group = 2
Group = factor(c(rep(0, n.sample*n.timepoints), rep(1,n.sample*n.timepoints)))
Time = rep(rep(1:n.timepoints, times = n.sample), 2)
ID = factor(rep(1:(2*n.sample), each = n.timepoints))
points = seq(1, 10, length.out = 10)
\dontrun{
output.nbinomial = metalonda(Count = metalonda_test_data[1,], Time = Time, Group = Group,
ID = ID, fit.method =  "nbinomial", n.perm = 10, points = points,
text = rownames(metalonda_test_data)[1], parall = FALSE, pvalue.threshold = 0.05, 
adjust.method = "BH", time.unit = "hours", ylabel = "Normalized Count", col = c("black", "green"))
}
}
\references{
Ahmed Metwally (ametwall@stanford.edu)
}
