% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{robust_test}
\alias{robust_test}
\alias{plot.robust}
\title{Robust_test for a network}
\usage{
robust_test(
  go_ls,
  partial = 0.5,
  step = 10,
  reps = 9,
  threads = 1,
  verbose = TRUE
)

\method{plot}{robust}(
  x,
  indexes = c("Natural_connectivity", "Average_path_length", "Average_degree"),
  use_ratio = FALSE,
  mode = 1,
  ...
)
}
\arguments{
\item{go_ls}{an igraph object or igraph list.}

\item{partial}{how much percent vertexes be removed in total}

\item{step}{how many nodes be removed each time?}

\item{reps}{simulation number}

\item{threads}{threads}

\item{verbose}{verbose}

\item{x}{\code{robust_test()} result (robust object)}

\item{indexes}{indexes selected to show}

\item{use_ratio}{use the delete nodes ratio rather than nodes number}

\item{mode}{plot mode, 1~3}

\item{...}{additional arguments for \code{\link[pcutils]{group_box}}}
}
\value{
dataframe(robustness class)

a ggplot
}
\description{
Robust_test for a network

Plot robust
}
\examples{
\donttest{
data("c_net")
robust_test(co_net, step = 20, reps = 9) -> robust_res
plot(robust_res, index = "Average_degree", mode = 2)
}
}
