% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa2005.R
\name{epa2005}
\alias{epa2005}
\title{Download data from the Encuesta de Población Activa (EPA)}
\usage{
epa2005(file)
}
\arguments{
\item{file}{Character string with the name of the microdata file provided by the INE on the
\href{http://www.ine.es/dyngs/INEbase/es/operacion.htm?c=Estadistica_C&cid=1254736176918&menu=resultados&secc=1254736030639&idp=1254735976595}{EPA} section. It allows either a path to a file,
or literal data (single string or raw vector). It also allows compressed files in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} format.}
}
\value{
\code{\link[tibble]{tibble}} with all avaliable requested data where each row corresponds to an anonymised citizen.
}
\description{
This function downloads the data from the Spanish Active Population Survey using the information provided by the Spanish Statistical Office (INE).
}
\details{
This function reads microdata from the quarterly Active Population Survey in Spain. It was originally built using the metadata for 2005 file but it may be used for later years. Previous files have a different, non compatible, format.
}
\note{
The \code{file} parameter allows any flat file with fixed width.
}
\examples{
\dontrun{
raw <- epa2005("EPA4T017")
summary(raw)
}
}
\references{
http://www.ine.es/prodyser/microdatos.htm
}
\seealso{
\code{\link[readr]{read_fwf}} to read fixed width files.
}
\author{
Carlos J. Gil Bellosta
}
