% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{summary_plot_pq}
\alias{summary_plot_pq}
\title{Summarize a \code{\link[phyloseq]{phyloseq-class}} object using a plot.}
\usage{
summary_plot_pq(
  physeq,
  add_info = TRUE,
  min_seq_samples = 500,
  clean_pq = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{add_info}{Does the bottom down corner contain
extra informations?}

\item{min_seq_samples}{(int): Used only when add_info is set
to true to print the number of samples with less sequences than
this number.}

\item{clean_pq}{(logical): Does the phyloseq
object is cleaned using the \code{\link[=clean_pq]{clean_pq()}} function?}
}
\value{
A ggplot2 object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Graphical representation of a phyloseq object.
}
\examples{

summary_plot_pq(data_fungi)
summary_plot_pq(data_fungi, add_info = FALSE) + scale_fill_viridis_d()
}
