% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterDiagGaussian.R
\docType{class}
\name{ClusterDiagGaussian}
\alias{ClusterDiagGaussian}
\alias{ClusterDiagGaussian-class}
\title{Definition of the [\code{\linkS4class{ClusterDiagGaussian}}] class}
\description{
This class defines a diagonal Gaussian mixture Model.
}
\details{
This class inherits from the [\code{\linkS4class{IClusterModelBase}}] class.
A diagonal gaussian model is a mixture model of the form:
\deqn{
  f({x}|\boldsymbol{\theta})
  =\sum_{k=1}^K p_k \prod_{j=1}^d \phi(x_j;\mu_{jk},\sigma^2_{jk})
   \quad x \in {R}^d.
}
}
\section{Slots}{

\describe{
\item{\code{component}}{A [\code{\linkS4class{ClusterDiagGaussianComponent}}] with the
mean and standard deviation of the diagonal mixture model.}
}}
\examples{
getSlots("ClusterDiagGaussian")
data(geyser)
new("ClusterDiagGaussian", data=geyser)
}
\author{
Serge Iovleff
}
\seealso{
[\code{\linkS4class{IClusterModelBase}}] class
}

