% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmm.R
\name{kmmStrategy}
\alias{kmmStrategy}
\title{Create an instance of [\code{\linkS4class{ClusterStrategy}}] class}
\usage{
kmmStrategy(nbTry = 1, nbInit = 5, initMethod = "class",
  initAlgo = "EM", nbInitIteration = 20, initEpsilon = 0.01,
  nbShortRun = 5, shortRunAlgo = "EM", nbShortIteration = 100,
  shortEpsilon = 1e-04, longRunAlgo = "EM", nbLongIteration = 1000,
  longEpsilon = 1e-07)
}
\arguments{
\item{nbTry}{Integer defining the number of estimation to attempt.}

\item{nbInit}{Integer defining the number of initialization to try. Default value: 3.}

\item{initMethod}{Character string with the initialization method, see [\code{\link{clusterInit}}]$
for possible values. Default value: "class".}

\item{initAlgo}{Character string with the algorithm to use in the initialization stage,
[\code{\link{clusterAlgo}}] for possible values. Default value: "EM".}

\item{nbInitIteration}{Integer defining the maximal number of iterations in
initialization algorithm if \code{initAlgo} = "EM" or "CEM", the number of iterations
if \code{initAlgo} = "SEM". Default value: 20.}

\item{initEpsilon}{Real defining the epsilon value for the initialization algorithm.
Not used if  \code{initAlgo} = "SEM". Default value: 0.01.}

\item{nbShortRun}{Integer defining the number of short run to try
(the strategy launch an initialization before each short run). Default value: 5.}

\item{shortRunAlgo}{A character string with the algorithm to use in the short run stage.
Default value: "EM".}

\item{nbShortIteration}{Integer defining the maximal number of iterations during
sa hort run if \code{shortRunAlgo} = "EM" or "CEM", the number of iterations
if \code{shortRunAlgo} = "SEM". Default value: 100.}

\item{shortEpsilon}{Real defining the epsilon value for the algorithm. Not used
if \code{shortRunAlgo} = "SEM". Default value: 1e-04.}

\item{longRunAlgo}{A character string with the algorithm to use in the long run stage.
Default value: "EM".}

\item{nbLongIteration}{Integer defining the maximal number of iterations during
a long run algorithm if \code{longRunAlgo} = "EM" or "CEM", the number of iterations
if \code{longRunAlgo} = "SEM". Default value: 1000.}

\item{longEpsilon}{Real defining the epsilon value for the algorithm.
Nor used if \code{longRunAlgo} = "SEM". Default value: 1e-07.}
}
\value{
a [\code{\linkS4class{ClusterStrategy}}] object
}
\description{
A strategy is a multistage empirical process for finding a
good estimate in the clustering estimation process.
}
\details{
A strategy is a way to find a good estimate of the parameters of a kernel
mixture model when using an EM algorithm or its variants. A ``try'' of
kmmStrategy is composed of three stages
\itemize{
  \item \code{nbShortRun} short iterations of the initialization step and
   of the \code{EM}, \code{CEM} or \code{SEM} algorithm.
  \item \code{nbInit} initializations using the [\code{\link{clusterInit}}]
  method.
  \item A long run of the \code{EM}, \code{CEM} or \code{SEM} algorithm.
}
For example if \code{nbInit} is 5 and \code{nbShortRun} is also 5, there will
be 5 times 5 models initialized. Five time, the best model (in the likelihood sense)
will be ameliorated using a short run. Among the 5 models ameliorated one will be
estimated until convergence using a long run. In total there is 25 initializations.

The whole process can be repeated at least \code{nbTry} times. If a try
success, the estimated model is returned, otherwise an empty model is returned.
}
\examples{
   kmmStrategy()
   kmmStrategy(longRunAlgo= "CEM", nbLongIteration=100)
   kmmStrategy(nbTry = 1, nbInit= 1, shortRunAlgo= "EM", nbShortIteration=100)

}
\author{
Serge Iovleff
}
