% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_area.R
\name{calc_area}
\alias{calc_area}
\title{Calculate the normalized surface area of the source convex hull}
\usage{
calc_area(source, mix, discr)
}
\arguments{
\item{source}{output from \code{\link{load_source_data}}}

\item{mix}{output from \code{\link{load_mix_data}}}

\item{discr}{output from \code{\link{load_discr_data}}}
}
\value{
If source$by_factor = FALSE, \code{calc_area} returns a scalar, the
  normalized surface area of the SOURCE + TDF convex hull

If source$by_factor = TRUE, \code{calc_area} returns a vector, where
  the entries are the normalized surface areas of the convex hull of each
  source factor level (e.g. source data by 3 Regions, returns a 3-vector of
  the areas of the Region 1 convex hull, Region 2 convex hull, etc.)
}
\description{
\code{calc_area()} calculates the normalized surface area of the SOURCE + TDF
 convex hull, only if there are exactly 2 biotracers.
}
\details{
Important detail is that, unlike in Brett (2014), \code{calc_area} uses the
combined SOURCE + TDF variance to normalize the surface area:
\deqn{\sqrt{\sigma^2_source + \sigma^2_discr}}
This is the variance used in fitting the mixing model.

\code{calc_area()} relies on the \code{splancs::areapl()} function from the \code{splancs}
package. If \code{splancs} is not installed, a WARNING message will appear.
}
\seealso{
Brett (2014): \url{https://www.researchgate.net/profile/Michael_Brett/publication/269873625_Resource_polygon_geometry_predicts_Bayesian_stable_isotope_mixing_model_bias/links/549884090cf2519f5a1de635.pdf}
}
