% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogconcave.R
\name{EMnormal}
\alias{EMnormal}
\title{Parameter Estimation of Multivariate Normal Mixture Using EM Algorithm}
\usage{
EMnormal(x, k)
}
\arguments{
\item{x}{Row vector of observations.}

\item{k}{Gaussian mixture with k components}
}
\value{
List of parameters: logL:best log-likelihood; pis: estimated component proportions;
mu:estimated component means; sig: estimated component sd.
}
\description{
Computes the parameter estimation of a possibly multivariate normal mixture model
using EM algorithm. The result is a input for EMlogconc function.
}
\details{
Uses random initialization for 20 restarts;
Stopping criterion: relative change in log likelihood < 10^(-8);
}
\examples{

m=2;
x=rnorm(100,2,sqrt(2));x=matrix(x,nrow=100);x[1:60]=x[1:60]+5;
EMnorm = EMnormal(x,m);

}
