% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixtureMissing.R
\name{plot.MixtureMissing}
\alias{plot.MixtureMissing}
\title{Mixture Missing Plotting}
\usage{
\method{plot}{MixtureMissing}(x, ...)
}
\arguments{
\item{x}{A \code{MixtureMissing} object.}

\item{...}{Arguments to be passed to methods, such as graphical parameters.}
}
\value{
No return value, called to visualize the fitted model's results
}
\description{
Provide a parallel plot of up to the first 10 variables of a multivariate
data sets, and a line plot showing log-likelihood values at every iteration
during the EM algorithm. When applicable, pairwise scatter plots highlighting
outliers and/or observations whose values are missing but are replaced by
expectations obtained in the EM algorithm will be included.
}
\examples{

data('nm_5_noise_close_100')

#++++ With no missing values ++++#

X <- nm_5_noise_close_100[, 1:2]
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
plot(mod)

#++++ With missing values ++++#

set.seed(1234)

X <- hide_values(nm_5_noise_close_100[, 1:2], prop_cases = 0.1)
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
plot(mod)

}
