% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteLearning.R
\name{probDiscreteVariable}
\alias{probDiscreteVariable}
\title{Probability distribution of discrete variables}
\usage{
probDiscreteVariable(stateNames, Variable)
}
\arguments{
\item{stateNames}{A \code{"character"} array indicating the states of the variable.}

\item{Variable}{A \code{"numeric"} array containing the records of the variable.}
}
\value{
A list of  \code{"numeric"} arrays:
\item{coeff}{Contains the probabilities.}
\item{sizeDataLeaf}{Number of records in each leaf of the discrete tree.}
}
\description{
Compute the probabilities of a discrete variable from a dataset.
}
\examples{
## Discrete Variable
data <- data.frame(X=rep(c("yes", "no", "maybe"), 500))
data <- discreteVariables_as.character(data, "X")
n <- nrow(data)

## Probabilities
s <- discreteVariablesStates(namevariables="X", discreteData=data)
states <- s[[1]]$states
p <- probDiscreteVariable(stateNames=states, Variable=data$X)
p

}
\seealso{
\link{discreteVariablesStates}
}
