% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{sample_MoTBFs}
\alias{sample_MoTBFs}
\title{Sample generation from conditional MoTBFs}
\usage{
sample_MoTBFs(bn, dag, obs = NULL, size, force_size = T)
}
\arguments{
\item{bn}{A list of lists obtained from the function \link{MoTBFs_Learning}.}

\item{dag}{An object of class \code{"bn"}, representing the directed acyclic graph.}

\item{obs}{A \code{data.frame} containing the observed variables. This argument can be omitted if no variable is observed.}

\item{size}{A non-negative integer giving the number of instances to be generated.}

\item{force_size}{\code{logical} indicating if the sample must be of the size indicated. As a default, it is set to TRUE.}
}
\value{
A \code{data.frame} containing the generated sample.
}
\description{
This function generates a sample from conditional MoTBFs.
}
\examples{

## Dataset
  data("ecoli", package = "MoTBFs")
  data <- ecoli[,-c(1,9)]

## Get directed acyclic graph
  dag <- LearningHC(data)
  
## Learn bayesian network
  bn <- MoTBFs_Learning(dag, data = data, numIntervals = 4, POTENTIAL_TYPE = "MTE")
  
## Specify the evidence set 
  obs <- data.frame(lip = "0.48", alm1 = 0.55, gvh = 1, stringsAsFactors=FALSE)
  
## Get the conditional sample
  sample_MoTBFs(bn, dag, obs, size = 10)
  
}
