% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-LDA.R
\name{plot_CV2}
\alias{plot_CV2}
\alias{plot_CV2.LDA}
\alias{plot_CV2.table}
\title{Plots a cross-correlation table}
\usage{
plot_CV2(x, ...)

\method{plot_CV2}{LDA}(x, ...)

\method{plot_CV2}{table}(x, links.FUN = arrows, col = TRUE,
  col0 = "black", col.breaks = 5, palette = col_heat, lwd = TRUE,
  lwd0 = 5, gap.dots = 0.2, pch.dots = 20, gap.names = 0.25,
  cex.names = 1, legend = TRUE, ...)
}
\arguments{
\item{x}{an \link{LDA} object, a table or a squared matrix}

\item{...}{useless here.}

\item{links.FUN}{a function to draw the links: eg \link{segments} (by default), \link{arrows}, etc.}

\item{col}{logical whether to vary the color of the links}

\item{col0}{a color for the default link (when \code{col = FALSE})}

\item{col.breaks}{the number of different colors}

\item{palette}{a color palette, eg \link{col_summer}, \link{col_hot}, etc.}

\item{lwd}{logical whether to vary the width of the links}

\item{lwd0}{a width for the default link (when \code{lwd = FALSE})}

\item{gap.dots}{numeric to set space between the dots and the links}

\item{pch.dots}{a pch for the dots}

\item{gap.names}{numeric to set the space between the dots and the group names}

\item{cex.names}{a cex for the names}

\item{legend}{logical whether to add a legend}
}
\description{
Or any contingency/confusion table. A simple graphic representation based on variable
width and/or color for arrows or segments, based on the relative frequencies.
}
\examples{
# Below various table that you can try. We will use the last one for the examples.
\dontrun{
#pure random
a <- sample(rep(letters[1:4], each=10))
b <- sample(rep(letters[1:4], each=10))
tab <- table(a, b)

# veryhuge + some structure
a <- sample(rep(letters[1:10], each=10))
b <- sample(rep(letters[1:10], each=10))
tab <- table(a, b)
diag(tab) <- round(runif(10, 10, 20))

tab <- matrix(c(8, 3, 1, 0, 0,
                2, 7, 1, 2, 3,
                3, 5, 9, 1, 1,
                1, 1, 2, 7, 1,
                0, 9, 1, 4, 5), 5, 5, byrow=TRUE)
tab <- as.table(tab)
}
# good prediction
tab <- matrix(c(8, 1, 1, 0, 0,
               1, 7, 1, 0, 0,
                1, 2, 9, 1, 0,
                1, 1, 1, 7, 1,
                0, 0, 0, 1, 8), 5, 5, byrow=TRUE)
tab <- as.table(tab)


plot_CV2(tab)
plot_CV2(tab, arrows) # if you prefer arrows
plot_CV2(tab, lwd=FALSE, lwd0=1, palette=col_india) # if you like india but not lwds
plot_CV2(tab, col=FALSE, col0='pink') # only lwd
plot_CV2(tab, col=FALSE, lwd0=10, cex.names=2) # if you're getting old
plot_CV2(tab, col=FALSE, lwd=FALSE) # pretty but useless
plot_CV2(tab, col.breaks=2) # if you think it's either good or bad
plot_CV2(tab, pch=NA) # if you do not like dots
plot_CV2(tab, gap.dots=0) # if you want to 'fill the gap'
plot_CV2(tab, gap.dots=1) # or not

#trilo examples
data(trilo)
trilo.f <- efourier(trilo, 8)
trilo.l <- LDA(PCA(trilo.f), 'onto')
trilo.l
plot_CV2(trilo.l)

# olea example
data(olea)
op <- opoly(olea, 5)
opl <- LDA(PCA(op), 'var')
plot_CV2(opl)
}
\seealso{
\link{LDA}, \link{plot.LDA}, \link{plot_CV}.
}
