% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.sem.sim.R
\name{fit.simulation}
\alias{fit.simulation}
\title{This function runs a model for simulated data by using lavaan package.}
\usage{
fit.simulation(model, PEmethod = "ML", dataList = "Data_List.dat", f.loc)
}
\arguments{
\item{model}{Lavaan model}

\item{PEmethod}{Parameter estimation method. The default  is ML.}

\item{dataList}{List of the names of data sets generated earlier.}

\item{f.loc}{File location. It indicates where the simulated data sets are located.}
}
\description{
Generated data sets (Generated by sim.skewed() or sim.normal() functions) will be fitted to pre-specified model. The lavaan package is used to fit the model.
After running the model, fit indices and parameters estimated with their standard errors will be printed to a Comma Separated Values (csv) file.
The name of the output file is "All_Results.csv". Each line in the file represents results of a simulation.
The columns are self explanatory but the second column (named Notes) needs more detailed explanation.
This column shows if the model convergency. If the model is converged without any problem the value will be "CONVERGE"
If it is not converged the value will be "NONCONVERGE" and all the values in the line will be "NA"
If there are some kind of warning (such as negative variance) during the model run the value will be "WARNING" and based on the warning type some of the values might me "NA".
To run the simulation previously generated data sets and the list of the data sets (Data_List.dat) should be located into the same folder at the working directory.
}
\examples{
\donttest{
lavaanM<-'
#CFA Model
f1	=~ NA*x1 + x2 + x3
f2	=~ NA*x4 + x5 + x6
f3 =~ NA*x7 + x8
#Factor Correlations
f1	~~ f2
f1	~~ f3
f2	~~ f3
#Factor variance
f1	~~ 1*f1
f2	~~ 1*f2
f3	~~ 1*f3
'
dl<-"Data_List.dat"  # should be located in the working directory.

fit.simulation(model=lavaanM, PEmethod="MLR", dataList=dl, f.loc=tempdir())
}
}
\author{
Fatih Orcan
}
