% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.r
\name{Partition_Indecomposable}
\alias{Partition_Indecomposable}
\title{Building indecomposable partitions}
\usage{
Partition_Indecomposable(L)
}
\arguments{
\item{L}{A partition matrix}
}
\value{
\code{IndecompK2L} A list of partition matrices
indecomposable with respect to L

\code{numb_by_sizes} A vector indicating the number of indecomposable partitions
with respect to L by sizes
}
\description{
Produces the list of all indecomposable partitions
with respect to the partition matrix L
}
\examples{
L<-matrix(c(1,1,0,0,0,0,1,1),2,4,byrow=TRUE)
IP<-Partition_Indecomposable(L)
IP$IndecompK2L
IP$num_by_sizes

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 1.4.6
}
\seealso{
Other Partitions: 
\code{\link{Partition_2Perm}()},
\code{\link{Partition_Pairs}()},
\code{\link{Partition_Type_All}()},
\code{\link{Permutation_Inverse}()}
}
\concept{Partitions}
