/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.stats;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import net.myrrix.common.stats.IntWeightedMean;
import net.myrrix.common.stats.RunningStatistics;

public final class RunningStatisticsPerTime
implements Serializable {
    private final IntWeightedMean mean;
    private double min;
    private double max;
    private final long bucketTimeMS;
    private final Deque<RunningStatistics> subBuckets;
    private long frontBucketValidUntil;

    public RunningStatisticsPerTime(TimeUnit timeUnit) {
        int timeUnitOrdinal = timeUnit.ordinal();
        Preconditions.checkArgument(timeUnitOrdinal >= TimeUnit.MINUTES.ordinal(), "Unsupported time unit: %s", new Object[]{timeUnit});
        TimeUnit subTimeUnit = TimeUnit.values()[timeUnitOrdinal - 1];
        int numBuckets = (int)subTimeUnit.convert(1L, timeUnit);
        this.mean = new IntWeightedMean();
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.bucketTimeMS = TimeUnit.MILLISECONDS.convert(1L, subTimeUnit);
        this.subBuckets = new LinkedList<RunningStatistics>();
        for (int i = 0; i < numBuckets; ++i) {
            this.subBuckets.add(new RunningStatistics());
        }
        this.frontBucketValidUntil = System.currentTimeMillis() + this.bucketTimeMS;
    }

    public synchronized void refresh() {
        long now = System.currentTimeMillis();
        while (now > this.frontBucketValidUntil) {
            RunningStatistics removedBucket = this.subBuckets.removeLast();
            int count = removedBucket.getCount();
            if (count > 0) {
                this.mean.decrement(removedBucket.getAverage(), count);
            }
            if (removedBucket.getMin() <= this.min) {
                double newMin = Double.NaN;
                for (RunningStatistics bucket : this.subBuckets) {
                    double bucketMin = bucket.getMin();
                    if (!Double.isNaN(newMin) && !(bucketMin < newMin)) continue;
                    newMin = bucketMin;
                }
                this.min = newMin;
            }
            if (removedBucket.getMax() >= this.max) {
                double newMax = Double.NaN;
                for (RunningStatistics bucket : this.subBuckets) {
                    double bucketMax = bucket.getMax();
                    if (!Double.isNaN(newMax) && !(bucketMax > newMax)) continue;
                    newMax = bucketMax;
                }
                this.max = newMax;
            }
            this.subBuckets.addFirst(new RunningStatistics());
            this.frontBucketValidUntil += this.bucketTimeMS;
        }
    }

    public synchronized void increment(double value) {
        this.refresh();
        this.mean.increment(value);
        this.subBuckets.getFirst().addDatum(value);
        if (Double.isNaN(this.min) || value < this.min) {
            this.min = value;
        }
        if (Double.isNaN(this.max) || value > this.max) {
            this.max = value;
        }
    }

    public synchronized long getCount() {
        return this.mean.getN();
    }

    public synchronized double getMean() {
        return this.mean.getResult();
    }

    public synchronized double getMin() {
        return this.min;
    }

    public synchronized double getMax() {
        return this.max;
    }
}

