/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.parallel.Paralleler;
import net.myrrix.common.parallel.Processor;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.eval.AbstractEvaluator;
import net.myrrix.online.eval.EvaluationResult;
import net.myrrix.online.eval.IRStatisticsImpl;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrecisionRecallEvaluator
extends AbstractEvaluator {
    private static final Logger log = LoggerFactory.getLogger(PrecisionRecallEvaluator.class);
    private static final double LN2 = Math.log(2.0);

    @Override
    protected boolean isSplitTestByPrefValue() {
        return true;
    }

    @Override
    public EvaluationResult evaluate(final MyrrixRecommender recommender, final RescorerProvider provider, final Multimap<Long, RecommendedItem> testData) throws TasteException {
        final Mean precision = new Mean();
        final Mean recall = new Mean();
        final Mean ndcg = new Mean();
        final Mean meanAveragePrecision = new Mean();
        Processor<Long> processor = new Processor<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Long userID, long count) {
                List<RecommendedItem> recs;
                Collection values = testData.get(userID);
                int numValues = values.size();
                if (numValues == 0) {
                    return;
                }
                IDRescorer rescorer = provider == null ? null : provider.getRecommendRescorer(new long[]{userID}, recommender, new String[0]);
                try {
                    recs = recommender.recommend(userID, numValues, rescorer);
                }
                catch (NoSuchUserException nsue) {
                    log.warn("User only in test data: {}", (Object)userID);
                    return;
                }
                catch (TasteException te) {
                    log.warn("Unexpected exception", te);
                    return;
                }
                int numRecs = recs.size();
                HashSet<Long> valueIDs = Sets.newHashSet();
                for (RecommendedItem rec : values) {
                    valueIDs.add(rec.getItemID());
                }
                int intersectionSize = 0;
                double score = 0.0;
                double maxScore = 0.0;
                Mean precisionAtI = new Mean();
                double averagePrecision = 0.0;
                for (int i = 0; i < numRecs; ++i) {
                    RecommendedItem rec = recs.get(i);
                    double value = LN2 / Math.log(2.0 + (double)i);
                    if (valueIDs.contains(rec.getItemID())) {
                        ++intersectionSize;
                        score += value;
                        precisionAtI.increment(1.0);
                        averagePrecision += precisionAtI.getResult();
                    } else {
                        precisionAtI.increment(0.0);
                    }
                    maxScore += value;
                }
                averagePrecision /= (double)numValues;
                Mean mean = precision;
                synchronized (mean) {
                    precision.increment(numRecs == 0 ? 0.0 : (double)intersectionSize / (double)numRecs);
                    recall.increment((double)intersectionSize / (double)numValues);
                    ndcg.increment(maxScore == 0.0 ? 0.0 : score / maxScore);
                    meanAveragePrecision.increment(averagePrecision);
                    if (count % 10000L == 0L) {
                        log.info(new IRStatisticsImpl(precision.getResult(), recall.getResult(), ndcg.getResult(), meanAveragePrecision.getResult()).toString());
                    }
                }
            }
        };
        Paralleler<Long> paralleler = new Paralleler<Long>(testData.keySet().iterator(), processor, "PREval");
        try {
            if (Boolean.parseBoolean(System.getProperty("eval.parallel", "true"))) {
                paralleler.runInParallel();
            } else {
                paralleler.runInSerial();
            }
        }
        catch (InterruptedException ie) {
            throw new TasteException(ie);
        }
        catch (ExecutionException e) {
            throw new TasteException(e.getCause());
        }
        IRStatisticsImpl result = new IRStatisticsImpl(precision.getResult(), recall.getResult(), ndcg.getResult(), meanAveragePrecision.getResult());
        log.info(((Object)result).toString());
        return result;
    }

    public static void main(String[] args) throws Exception {
        PrecisionRecallEvaluator eval = new PrecisionRecallEvaluator();
        EvaluationResult result = eval.evaluate(new File(args[0]));
        log.info(result.toString());
    }
}

