/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.item.AggregateAndRecommendReducer;
import org.apache.mahout.cf.taste.hadoop.item.ItemFilterAsVectorAndPrefsReducer;
import org.apache.mahout.cf.taste.hadoop.item.ItemFilterMapper;
import org.apache.mahout.cf.taste.hadoop.item.PartialMultiplyMapper;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.hadoop.item.SimilarityMatrixRowWrapperMapper;
import org.apache.mahout.cf.taste.hadoop.item.ToVectorAndPrefReducer;
import org.apache.mahout.cf.taste.hadoop.item.UserVectorSplitterMapper;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.cf.taste.hadoop.item.VectorOrPrefWritable;
import org.apache.mahout.cf.taste.hadoop.preparation.PreparePreferenceMatrixJob;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.RowSimilarityJob;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.VectorSimilarityMeasures;

public final class RecommenderJob
extends AbstractJob {
    public static final String BOOLEAN_DATA = "booleanData";
    private static final int DEFAULT_MAX_SIMILARITIES_PER_ITEM = 100;
    private static final int DEFAULT_MAX_PREFS_PER_USER = 1000;
    private static final int DEFAULT_MIN_PREFS_PER_USER = 1;

    public int run(String[] args) throws Exception {
        boolean succeeded;
        this.addInputOption();
        this.addOutputOption();
        this.addOption("numRecommendations", "n", "Number of recommendations per user", String.valueOf(10));
        this.addOption("usersFile", null, "File of users to recommend for", null);
        this.addOption("itemsFile", null, "File of items to recommend for", null);
        this.addOption("filterFile", "f", "File containing comma-separated userID,itemID pairs. Used to exclude the item from the recommendations for that user (optional)", null);
        this.addOption(BOOLEAN_DATA, "b", "Treat input as without pref values", Boolean.FALSE.toString());
        this.addOption("maxPrefsPerUser", "mxp", "Maximum number of preferences considered per user in final recommendation phase", String.valueOf(10));
        this.addOption("minPrefsPerUser", "mp", "ignore users with less preferences than this in the similarity computation (default: 1)", String.valueOf(1));
        this.addOption("maxSimilaritiesPerItem", "m", "Maximum number of similarities considered per item ", String.valueOf(100));
        this.addOption("maxPrefsPerUserInItemSimilarity", "mppuiis", "max number of preferences to consider per user in the item similarity computation phase, users with more preferences will be sampled down (default: 1000)", String.valueOf(1000));
        this.addOption("similarityClassname", "s", "Name of distributed similarity measures class to instantiate, alternatively use one of the predefined similarities (" + VectorSimilarityMeasures.list() + ')', true);
        this.addOption("threshold", "tr", "discard item pairs with a similarity value below this", false);
        Map<String, List<String>> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path outputPath = this.getOutputPath();
        int numRecommendations = Integer.parseInt(this.getOption("numRecommendations"));
        String usersFile = this.getOption("usersFile");
        String itemsFile = this.getOption("itemsFile");
        String filterFile = this.getOption("filterFile");
        boolean booleanData = Boolean.valueOf(this.getOption(BOOLEAN_DATA));
        int maxPrefsPerUser = Integer.parseInt(this.getOption("maxPrefsPerUser"));
        int minPrefsPerUser = Integer.parseInt(this.getOption("minPrefsPerUser"));
        int maxPrefsPerUserInItemSimilarity = Integer.parseInt(this.getOption("maxPrefsPerUserInItemSimilarity"));
        int maxSimilaritiesPerItem = Integer.parseInt(this.getOption("maxSimilaritiesPerItem"));
        String similarityClassname = this.getOption("similarityClassname");
        double threshold = this.hasOption("threshold") ? Double.parseDouble(this.getOption("threshold")) : Double.MIN_VALUE;
        Path prepPath = this.getTempPath("preparePreferenceMatrix");
        Path similarityMatrixPath = this.getTempPath("similarityMatrix");
        Path prePartialMultiplyPath1 = this.getTempPath("prePartialMultiply1");
        Path prePartialMultiplyPath2 = this.getTempPath("prePartialMultiply2");
        Path explicitFilterPath = this.getTempPath("explicitFilterPath");
        Path partialMultiplyPath = this.getTempPath("partialMultiply");
        AtomicInteger currentPhase = new AtomicInteger();
        int numberOfUsers = -1;
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            ToolRunner.run((Configuration)this.getConf(), (Tool)new PreparePreferenceMatrixJob(), (String[])new String[]{"--input", this.getInputPath().toString(), "--output", prepPath.toString(), "--maxPrefsPerUser", String.valueOf(maxPrefsPerUserInItemSimilarity), "--minPrefsPerUser", String.valueOf(minPrefsPerUser), "--booleanData", String.valueOf(booleanData), "--tempDir", this.getTempPath().toString()});
            numberOfUsers = HadoopUtil.readInt(new Path(prepPath, "numUsers.bin"), this.getConf());
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            if (numberOfUsers == -1) {
                numberOfUsers = (int)HadoopUtil.countRecords(new Path(prepPath, "userVectors"), PathType.LIST, null, this.getConf());
            }
            ToolRunner.run((Configuration)this.getConf(), (Tool)new RowSimilarityJob(), (String[])new String[]{"--input", new Path(prepPath, "ratingMatrix").toString(), "--output", similarityMatrixPath.toString(), "--numberOfColumns", String.valueOf(numberOfUsers), "--similarityClassname", similarityClassname, "--maxSimilaritiesPerRow", String.valueOf(maxSimilaritiesPerItem), "--excludeSelfSimilarity", String.valueOf(Boolean.TRUE), "--threshold", String.valueOf(threshold), "--tempDir", this.getTempPath().toString()});
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job prePartialMultiply1 = this.prepareJob(similarityMatrixPath, prePartialMultiplyPath1, SequenceFileInputFormat.class, SimilarityMatrixRowWrapperMapper.class, VarIntWritable.class, VectorOrPrefWritable.class, Reducer.class, VarIntWritable.class, VectorOrPrefWritable.class, SequenceFileOutputFormat.class);
            succeeded = prePartialMultiply1.waitForCompletion(true);
            if (!succeeded) {
                return -1;
            }
            Job prePartialMultiply2 = this.prepareJob(new Path(prepPath, "userVectors"), prePartialMultiplyPath2, SequenceFileInputFormat.class, UserVectorSplitterMapper.class, VarIntWritable.class, VectorOrPrefWritable.class, Reducer.class, VarIntWritable.class, VectorOrPrefWritable.class, SequenceFileOutputFormat.class);
            if (usersFile != null) {
                prePartialMultiply2.getConfiguration().set("usersFile", usersFile);
            }
            prePartialMultiply2.getConfiguration().setInt("maxPrefsPerUserConsidered", maxPrefsPerUser);
            succeeded = prePartialMultiply2.waitForCompletion(true);
            if (!succeeded) {
                return -1;
            }
            Job partialMultiply = this.prepareJob(new Path(prePartialMultiplyPath1 + "," + prePartialMultiplyPath2), partialMultiplyPath, SequenceFileInputFormat.class, Mapper.class, VarIntWritable.class, VectorOrPrefWritable.class, ToVectorAndPrefReducer.class, VarIntWritable.class, VectorAndPrefsWritable.class, SequenceFileOutputFormat.class);
            RecommenderJob.setS3SafeCombinedInputPath(partialMultiply, this.getTempPath(), prePartialMultiplyPath1, prePartialMultiplyPath2);
            succeeded = partialMultiply.waitForCompletion(true);
            if (!succeeded) {
                return -1;
            }
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job itemFiltering;
            if (filterFile != null && !(succeeded = (itemFiltering = this.prepareJob(new Path(filterFile), explicitFilterPath, TextInputFormat.class, ItemFilterMapper.class, VarLongWritable.class, VarLongWritable.class, ItemFilterAsVectorAndPrefsReducer.class, VarIntWritable.class, VectorAndPrefsWritable.class, SequenceFileOutputFormat.class)).waitForCompletion(true))) {
                return -1;
            }
            String aggregateAndRecommendInput = partialMultiplyPath.toString();
            if (filterFile != null) {
                aggregateAndRecommendInput = aggregateAndRecommendInput + "," + explicitFilterPath;
            }
            Job aggregateAndRecommend = this.prepareJob(new Path(aggregateAndRecommendInput), outputPath, SequenceFileInputFormat.class, PartialMultiplyMapper.class, VarLongWritable.class, PrefAndSimilarityColumnWritable.class, AggregateAndRecommendReducer.class, VarLongWritable.class, RecommendedItemsWritable.class, TextOutputFormat.class);
            Configuration aggregateAndRecommendConf = aggregateAndRecommend.getConfiguration();
            if (itemsFile != null) {
                aggregateAndRecommendConf.set("itemsFile", itemsFile);
            }
            if (filterFile != null) {
                RecommenderJob.setS3SafeCombinedInputPath(aggregateAndRecommend, this.getTempPath(), partialMultiplyPath, explicitFilterPath);
            }
            RecommenderJob.setIOSort((JobContext)aggregateAndRecommend);
            aggregateAndRecommendConf.set("itemIDIndexPath", new Path(prepPath, "itemIDIndex").toString());
            aggregateAndRecommendConf.setInt("numRecommendations", numRecommendations);
            aggregateAndRecommendConf.setBoolean(BOOLEAN_DATA, booleanData);
            boolean succeeded2 = aggregateAndRecommend.waitForCompletion(true);
            if (!succeeded2) {
                return -1;
            }
        }
        return 0;
    }

    private static void setIOSort(JobContext job) {
        Matcher m;
        Configuration conf = job.getConfiguration();
        conf.setInt("io.sort.factor", 100);
        String javaOpts = conf.get("mapred.map.child.java.opts");
        if (javaOpts == null) {
            javaOpts = conf.get("mapred.child.java.opts");
        }
        int assumedHeapSize = 512;
        if (javaOpts != null && (m = Pattern.compile("-Xmx([0-9]+)([mMgG])").matcher(javaOpts)).find()) {
            assumedHeapSize = Integer.parseInt(m.group(1));
            String megabyteOrGigabyte = m.group(2);
            if ("g".equalsIgnoreCase(megabyteOrGigabyte)) {
                assumedHeapSize *= 1024;
            }
        }
        conf.setInt("io.sort.mb", Math.min(assumedHeapSize / 2, 1024));
        conf.setInt("mapred.task.timeout", 3600000);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new RecommenderJob(), (String[])args);
    }
}

