/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.signal;

import net.myrrix.common.ClassUtils;
import net.myrrix.common.signal.SignalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignalManager {
    private static final Logger log = LoggerFactory.getLogger(SignalManager.class);
    private static final String IMPL_NAME = "net.myrrix.common.signal.SignalManagerPOSIXImpl";

    abstract void doRegister(Runnable var1, SignalType ... var2);

    public static void register(Runnable handler, SignalType ... types) {
        if (ClassUtils.classExists(IMPL_NAME)) {
            SignalManager manager = ClassUtils.loadInstanceOf(IMPL_NAME, SignalManager.class);
            manager.doRegister(handler, types);
        } else {
            log.warn("Unable to handle OS signals on this platform. Using Ctrl-C or kill to stop the server may result in loss of data");
        }
    }
}

