/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;

public final class PartialMultiplyMapper
extends Mapper<VarIntWritable, VectorAndPrefsWritable, VarLongWritable, PrefAndSimilarityColumnWritable> {
    protected void map(VarIntWritable key, VectorAndPrefsWritable vectorAndPrefsWritable, Mapper.Context context) throws IOException, InterruptedException {
        Vector similarityMatrixColumn = vectorAndPrefsWritable.getVector();
        List<Long> userIDs = vectorAndPrefsWritable.getUserIDs();
        List<Float> prefValues = vectorAndPrefsWritable.getValues();
        VarLongWritable userIDWritable = new VarLongWritable();
        PrefAndSimilarityColumnWritable prefAndSimilarityColumn = new PrefAndSimilarityColumnWritable();
        for (int i = 0; i < userIDs.size(); ++i) {
            long userID = userIDs.get(i);
            float prefValue = prefValues.get(i).floatValue();
            if (Float.isNaN(prefValue)) continue;
            prefAndSimilarityColumn.set(prefValue, similarityMatrixColumn);
            userIDWritable.set(userID);
            context.write((Object)userIDWritable, (Object)prefAndSimilarityColumn);
        }
    }
}

