/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.knn;

import java.util.Arrays;
import org.apache.mahout.cf.taste.impl.recommender.knn.Optimizer;

public final class NonNegativeQuadraticOptimizer
implements Optimizer {
    private static final double EPSILON = 1.0E-10;
    private static final double CONVERGENCE_LIMIT = 0.1;
    private static final int MAX_ITERATIONS = 1000;
    private static final double DEFAULT_STEP = 0.001;

    @Override
    public double[] optimize(double[][] matrix, double[] b) {
        int k = b.length;
        double[] r = new double[k];
        double[] x = new double[k];
        Arrays.fill(x, 3.0 / (double)k);
        for (int iteration = 0; iteration < 1000; ++iteration) {
            int n;
            double rdot = 0.0;
            for (int n2 = 0; n2 < k; ++n2) {
                double sumAw = 0.0;
                double[] rowAn = matrix[n2];
                for (int i = 0; i < k; ++i) {
                    sumAw += rowAn[i] * x[i];
                }
                double rn = b[n2] - sumAw;
                if (x[n2] < 1.0E-10 && rn < 0.0) {
                    rn = 0.0;
                } else {
                    rdot += rn * rn;
                }
                r[n2] = rn;
            }
            if (rdot <= 0.1) break;
            double rArdotSum = 0.0;
            for (int n3 = 0; n3 < k; ++n3) {
                double sumAr = 0.0;
                double[] rowAn = matrix[n3];
                for (int i = 0; i < k; ++i) {
                    sumAr += rowAn[i] * r[i];
                }
                rArdotSum += r[n3] * sumAr;
            }
            double stepSize = rdot / rArdotSum;
            if (Double.isNaN(stepSize)) {
                stepSize = 0.001;
            }
            for (n = 0; n < k; ++n) {
                if (!(r[n] < 0.0)) continue;
                double absStepSize = stepSize < 0.0 ? -stepSize : stepSize;
                stepSize = Math.min(absStepSize, Math.abs(x[n] / r[n])) * stepSize / absStepSize;
            }
            for (n = 0; n < k; ++n) {
                int n4 = n;
                x[n4] = x[n4] + stepSize * r[n];
                if (!(x[n] < 1.0E-10)) continue;
                x[n] = 0.0;
            }
        }
        return x;
    }
}

