% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_rcc.R
\name{load_rcc}
\alias{load_rcc}
\title{Produce a "nacho" object from RCC NanoString files}
\usage{
load_rcc(
  data_directory,
  ssheet_csv,
  id_colname = NULL,
  housekeeping_genes = NULL,
  housekeeping_predict = FALSE,
  housekeeping_norm = TRUE,
  normalisation_method = "GEO",
  n_comp = 10
)
}
\arguments{
\item{data_directory}{[\link{character}] A character string of the directory where the data are stored.}

\item{ssheet_csv}{[\link{character}] or [\link{data.frame}] Either a string with the name of the CSV
of the samplesheet or the samplesheet as a \code{data.frame}.
Should contain a column that matches the file names in the folder.}

\item{id_colname}{[\link{character}] Character string of the column in \code{ssheet_csv} that matches
the file names in \code{data_directory}.}

\item{housekeeping_genes}{[\link{character}] A vector of names of the miRNAs/mRNAs
that should be used as housekeeping genes. Default is \code{NULL}.}

\item{housekeeping_predict}{[\link{logical}] Boolean to indicate whether the housekeeping genes
should be predicted (\code{TRUE}) or not (\code{FALSE}). Default is \code{FALSE}.}

\item{housekeeping_norm}{[\link{logical}] Boolean to indicate whether the housekeeping normalisation
should be performed. Default is \code{TRUE}.}

\item{normalisation_method}{[\link{character}] Either \code{"GEO"} or \code{"GLM"}.
Character string to indicate normalisation using the geometric mean (\code{"GEO"})
or a generalized linear model (\code{"GLM"}). Default is \code{"GEO"}.}

\item{n_comp}{[\link{numeric}] Number indicating the number of principal components to compute.
Cannot be more than n-1 samples. Default is \code{10}.}
}
\value{
[\link{list}] A list object of class \code{"nacho"}:
\describe{
\item{\code{access}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}} in \code{id_colname}.}
\item{\code{housekeeping_genes}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{housekeeping_predict}}{[\link{logical}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{housekeeping_norm}}{[\link{logical}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{normalisation_method}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{remove_outliers}}{[\link{logical}] \code{FALSE}.}
\item{\code{n_comp}}{[\link{numeric}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{data_directory}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{pc_sum}}{[\link{data.frame}] A \code{data.frame} with \code{n_comp} rows and four columns:
"Standard deviation", "Proportion of Variance", "Cumulative Proportion" and "PC".}
\item{\code{nacho}}{[\link{data.frame}] A \code{data.frame} with all columns from the sample sheet \code{ssheet_csv}
and all computed columns, \emph{i.e.}, quality-control metrics and counts, with one sample per row.}
\item{\code{outliers_thresholds}}{[\link{list}] A \code{list} of the (default) quality-control thresholds used.}
}
}
\description{
This function is used to preprocess the data from NanoString nCounter.
}
\examples{

if (interactive()) {
  library(GEOquery)
  library(NACHO)

  # Import data from GEO
  gse <- GEOquery::getGEO(GEO = "GSE74821")
  targets <- Biobase::pData(Biobase::phenoData(gse[[1]]))
  GEOquery::getGEOSuppFiles(GEO = "GSE74821", baseDir = tempdir())
  utils::untar(
    tarfile = file.path(tempdir(), "GSE74821", "GSE74821_RAW.tar"),
    exdir = file.path(tempdir(), "GSE74821")
  )
  targets$IDFILE <- list.files(
    path = file.path(tempdir(), "GSE74821"),
    pattern = ".RCC.gz$"
  )
  targets[] <- lapply(X = targets, FUN = iconv, from = "latin1", to = "ASCII")
  utils::write.csv(
    x = targets,
    file = file.path(tempdir(), "GSE74821", "Samplesheet.csv")
  )

  # Read RCC files and format
  nacho <- load_rcc(
    data_directory = file.path(tempdir(), "GSE74821"),
    ssheet_csv = file.path(tempdir(), "GSE74821", "Samplesheet.csv"),
    id_colname = "IDFILE"
  )
}

}
