% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenTolInt.R
\name{cenTolInt}
\alias{cenTolInt}
\title{Upper Tolerance interval for censored data}
\usage{
cenTolInt(
  x.var,
  cens.var,
  conf = 0.95,
  cover = 0.9,
  method.fit = "mle",
  printstat = TRUE
)
}
\arguments{
\item{x.var}{The column of x (response variable) values plus detection limits}

\item{cens.var}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{conf}{Confidence coefficient of the interval, 0.95 (default).}

\item{cover}{Coverage, the percentile probability above which the tolerance interval is computed.  The default is 90, so a tolerance interval will be computed above the 90th percentile of the data.}

\item{method.fit}{The method used to compute the parameters of the distribution.  The default is maximum likelihood (\verb{“mle”}). The alternative is robust ROS (\verb{“rROS”}).  See Details.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Prints and returns the percentile (\code{cover}), upper tolerance limit (\code{conf}) and BIC of fit for lognormal, normal and approximated gamma distributions. Plots empirical and theoretical CDFs with BIC values in the legend.
}
\description{
Computes a one-sided upper tolerance interval for censored data assuming log-normal, gamma and normal distributions.
}
\details{
Computes upper one-sided tolerance intervals for three distributions.  This is a front-end to the individual functions from the EnvStats package.  By default all three are computed using maximum likelihood estimation (mle); robust ROS is available as an alternate method for all three distributions. The gamma distribution for censored data uses the Wilson-Hilferty approximation (normal distribution on cube roots of data). For more info on the relative merits of robust ROS versus mle, see Helsel (2011) and Millard (2013).
}
\examples{

data(PbHeron)

# Default
cenTolInt(PbHeron$Liver,PbHeron$LiverCen)

# User defined conficence interval
cenTolInt(PbHeron$Liver,PbHeron$LiverCen,conf=0.75)

# User defined percentile
cenTolInt(PbHeron$Liver,PbHeron$LiverCen,cover=0.5)

# inputs outside acceptable ranges
# Will result in errors/warnings
# cenTolInt(PbHeron$Liver,PbHeron$LiverCen,cover=1.25)
# cenTolInt(PbHeron$Liver,PbHeron$LiverCen,conf=1.1)
# cenTolInt(PbHeron$Liver,PbHeron$LiverCen,method.fit="ROS")

}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Millard, S.P., 2013. EnvStats: An R Package for Environmental Statistics. Springer-Verlag, New York.

Krishnamoorthy, K., Mathew, T., Mukherjee, S., 2008. Normal-Based Methods for a Gamma Distribution, Technometrics, 50, 69-78.
}
