% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NFP-class.R
\docType{class}
\name{NFP-class}
\alias{NFP-class}
\title{\code{NFP-class}}
\description{
An S4 object for storing network fingerprint similarity score information.
}
\section{Slots}{

\describe{
\item{\code{raw_score,}}{a numeric vector, network fingerprint based on reference
networks before standardization.}

\item{\code{randomized_score,}}{a data frame, the permulated similarity score.}

\item{\code{standardized_score,}}{a numeric vector, the final standardized network fingerprint.}

\item{\code{cluster,}}{an \emph{APResult} list, more details see package **apcluster**,
each element provides a cluster information of a
biological network based on one reference networks.
#'@section method:
   \itemize{
     \item{perm_score, \code{signature(object = "NFP")}:
       extract the randomized similarity score}
     \item{cluster_info, \code{signature(object = "NFP")}:
       extract the cluster information}
     \item{sub_NFP, \code{signature(object = "NFP")}:
       subset of NFP object}
     \item{plot, \code{signature(object, type = "character", p_size = "numeric", l_size = 'numeric')}:
       plot NFP results}
     \item{show, \code{signature(object = "NFP")}:
       display methods for S4 classes NFP, see also
       \code{\link[methods]{show}}}
   }}
}}
\seealso{
\code{\link{show-methods}},
\code{\link{plot-methods}}, \code{\link{perm_score-methods}},
\code{\link{cluster_info-methods}}, \code{\link{sub_NFP-methods}}
}

