% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmAddReducedDim}
\alias{chmAddReducedDim}
\title{Add reduced dimension coordinates to an NG-CHM.}
\usage{
chmAddReducedDim(hm, axis, obj, dimName, maxDim, basename, dimAxis)
}
\arguments{
\item{hm}{The NGCHM to add the coordinates to.}

\item{axis}{The NGCHM axis ("row" or "column") to add the coordinates to.}

\item{obj}{An object containing the (reduced) dimension.}

\item{dimName}{The name of the (reduced) dimension to create covariate bars for.}

\item{maxDim}{The maximum number of coordinates to add (default all).}

\item{basename}{The prefix to use for the coordinate names (defaults to dimName).}

\item{dimAxis}{The axis on obj containing the named dimension, if applicable.}
}
\value{
The NGCHM with added coordinates.
}
\description{
Add (reduced) dimension coordinates from an object obj
as hidden covariate bars to an axis of an NG-CHM.  Depending on the object type, dimName and dimAxis
can be used to specify the name of the dimension of interest in obj.
}
\details{
One hidden covariate bar is added for each coordinate obtained from \code{obj}.
If specified, maxDim limits the maximum number of covariate bars added to the chm.

Coordinates have names 'BASENAME.coordinate.N', where BASENAME is specified by the parameter
basename (defaults to dimName if omitted) and N ranges from 1 to the number of added covariate bars.

\code{obj} can be a numeric matrix, each column of which is a (reduced) dimension.  In this case, dimName and dimAxis
are not used for obtaining the reduced dimension.  The number of rows of the matrix must equal the size of the specified
NGCHM axis and each row of the matrix must be uniquely named using the names from that axis of the NG-CHM.

\code{obj} can also be an instance of class className if there exists an S3 method getDimensions.className.
The method takes the object as its first parameter and up to two optional parameters, dimName and dimAxis,
that can be used to specify the desired dimension.  The method's return value is a matrix similar to
the one described in the preceding paragraph.  This package defines methods for classes \code{prcomp} and \code{umap}.
}
\examples{
# Examples using `chmNew()` require git to be installed.
\dontrun{
  if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
    data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
    mat <- TCGA.GBM.EXPR[1:10, 1:10]
    prc <- prcomp(mat)
    hm <- chmNew("Demo reduced dimension coordinates", mat)
    hm <- chmAddReducedDim(hm, "column", prc, "PCA", 3, "PC")
    umc <- umap::umap(t(mat), n_neighbors = 8)
    hm <- chmAddReducedDim(hm, "column", umc, "UMAP")
  }
  # Small example not requiring NGCHMDemoData
  matrix <- matrix(rnorm(100),
    nrow = 10, ncol = 10,
    dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
  )
  prc <- prcomp(matrix)
  hm <- chmNew("Demo reduced dimension coordinates", matrix)
  hm <- chmAddReducedDim(hm, "column", prc, "PCA", 3, "PC")
  umc <- umap::umap(t(matrix), n_neighbors = 8)
  hm <- chmAddReducedDim(hm, "column", umc, "UMAP")
}

}
\seealso{
\code{\link[=chmAddPCA]{chmAddPCA()}}

\code{\link[=chmAddTSNE]{chmAddTSNE()}}

\code{\link[=chmAddUMAP]{chmAddUMAP()}}

\code{\link[=chmAddUWOT]{chmAddUWOT()}}

\code{\link[=getDimensions]{getDimensions()}}
}
