% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNewColorMap}
\alias{chmNewColorMap}
\title{Create a new Color Map for use in constructing a NGCHM}
\usage{
chmNewColorMap(
  values,
  colors = NULL,
  names = NULL,
  shapes = NULL,
  zs = NULL,
  type = "linear",
  missing.color = NULL,
  palette = NULL
)
}
\arguments{
\item{values}{A vector specifying the series / break points for which the following colors are defined, or a data matrix.}

\item{colors}{Either a string vector specifying the color to use for each series / break point, or a single integer.}

\item{names}{A string vector specifying 'human-readable' names for each series / break point.}

\item{shapes}{A string vector specifying the shape to use for each series.}

\item{zs}{A numeric vector specifying the z order to use for each series.}

\item{type}{The string "linear" (default) or "quantile" (or unique abbreviation thereof).}

\item{missing.color}{A string specifying the color to use for missing data.}

\item{palette}{A function(n) that returns a vector of n colors.}
}
\value{
An object of class ngchmColormap
}
\description{
This function creates a new Color Map suitable for use in constructing Data Layers and Covariates
in Next Generation Clustered Heat Maps.  Color maps can be used in both discrete and continuous
contents.  In a discrete context, values specifies the properties of series.  In a continuous context,
values specifies the break points.
}
\details{
If values is a matrix, the function will estimate a suitable sequence of color break points.  For a quantile
color map, the matrix data is ignored.  For a linear color map, it will use equispaced values between a low value and
a high value. The low value is the median of the minima of each row in the matrix, and the high value is the median
of the row maxima. If the low and high values have different signs, the values will be symmetric about zero.
}
\examples{
noise.colors <- chmNewColorMap(c(0, 1, 2),
  c("green", "black", "red"),
  missing.color = "yellow"
)
bar.colors <- chmNewColorMap(c("small", "big"),
  c("#00FFFF", "#FF00FF"),
  type = "quantile"
)

}
\seealso{
\linkS4class{ngchmColormap}

\code{\link[=chmNewDataLayer]{chmNewDataLayer()}}

\code{\link[=chmNewCovariateBar]{chmNewCovariateBar()}}
}
