% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMwriteData.R
\name{NMwriteData}
\alias{NMwriteData}
\title{Write dataset for use in Nonmem (and R)}
\usage{
NMwriteData(
  data,
  file,
  write.csv = TRUE,
  write.rds = write.csv,
  write.RData = FALSE,
  script,
  args.stamp,
  args.fwrite,
  args.rds,
  args.RData,
  quiet,
  args.NMgenText,
  nm.drop,
  nmdir.data,
  col.flagn,
  nm.rename,
  nm.copy,
  nm.capitalize,
  allow.char.TIME
)
}
\arguments{
\item{data}{The dataset to write to file for use in Nonmem.}

\item{file}{The file to write to. The extension (everything after
and including last ".") is dropped. csv, rds and other
standard file name extensions are added.}

\item{write.csv}{Write to csv file?}

\item{write.rds}{write an rds file?}

\item{write.RData}{In case you want to save to .RData object. Not
recommended. Use write.rds instead.}

\item{script}{If provided, the object will be stamped with this
script name before saved to rds or Rdata. See ?NMstamp.}

\item{args.stamp}{A list of arguments to be passed to NMstamp.}

\item{args.fwrite}{List of arguments passed to fwrite. Notice that
except for "x" and "file", you need to supply all arguments to
fwrite if you use this argument. Default values can be
configured using NMdataConf.}

\item{args.rds}{A list of arguments to be passed to saveRDS.}

\item{args.RData}{A list of arguments to be passed to save.}

\item{quiet}{The default is to give some information along the way
on what data is found. But consider setting this to TRUE for
non-interactive use. Default can be configured using
NMdataConf.}

\item{args.NMgenText}{List of arguments to pass to NMgenText - the
function that generates text suggestion for INPUT and DATA
sections in the NONMEM control stream. You can use these
arguments to get a text suggestion you an use directly in
NONMEM - and NwriteSection can even update multiple NONMEM
control streams based on the result. This will update your
control streams to match your new data file with just one
command.}

\item{nm.drop}{Deprecated, use
args.NMgenText=list(drop=c("column")) instead.}

\item{nmdir.data}{Deprecated, use
args.NMgenText=list(dir.data="your/path") instead.}

\item{col.flagn}{Name of a numeric column with zero value for rows
to include in Nonmem run, non-zero for rows to skip. The
argument is only used for generating the proposed $DATA text to
paste into the Nonmem control stream. To skip this feature,
use col.flagn=NULL.}

\item{nm.rename}{Deprecated, use
args.NMgenText=list(rename=c(newname="existing")) instead.}

\item{nm.copy}{Deprecated, use
args.NMgenText=list(copy=c(newname="existing")) instead.}

\item{nm.capitalize}{Deprecated, use
args.NMgenText=list(capitalize=TRUE) instead.}

\item{allow.char.TIME}{Deprecated, use
args.NMgenText=list(allow.char.TIME=TRUE) instead.}
}
\value{
Text for inclusion in Nonmem control stream, invisibly.
}
\description{
Instead of trying to remember the arguments to pass to write.csv,
use this wrapper. It tells you what to write in $DATA and $INPUT
in nonmem, and it (additionally) exports an rds or Rdata file as
well which is highly preferable for use in R. It never edits the
data before writing the datafile. The filenames for csv, rds
etc. are derived by replacing the extension to the filename given
in the file argument.
}
\details{
When writing csv files, the file will be
    comma-separated. Because Nonmem does not support quoted
    fields, you must avoid commas in character fields. An error is
    returned if commas are found in strings.

The user is provided with text to use in Nonmem. This lists names
of the data columns. Once a column is reached that Nonmem will not
be able to read as a numeric and column is not in nm.drop, the list
is stopped. Only exception is TIME which is not tested for whether
character or not.
}
\seealso{
Other Nonmem: 
\code{\link{NMapplyFilters}()},
\code{\link{NMextractText}()},
\code{\link{NMgenText}()},
\code{\link{NMreadSection}()},
\code{\link{NMwriteSection}()}
}
\concept{Nonmem}
