% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMproject-options.R
\docType{data}
\name{sge_parallel_execute}
\alias{sge_parallel_execute}
\title{Generic execute command for SGE grids}
\format{
An object of class \code{character} of length 1.
}
\usage{
sge_parallel_execute
}
\value{
A \code{character} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Character to be used with the \code{\link[=cmd]{cmd()}} function to launch a parallelised job
on SGE.
}
\details{
Requires \code{cores} and \code{parafile} fields to be set.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv")) \%>\%
  cmd(sge_parallel_execute) \%>\%
  parafile("/opt/NONMEM/nm75/run/mpilinux8.pnm") \%>\%
  cores(8)
  
cmd(m1)

m2 <- m1 \%>\% child("m2") ## inherits same command as above

sge_parallel_execute ## view the character to see how psn interfaces with SGE
}
\seealso{
\code{\link[=nm_getsetters]{nm_getsetters()}}.
}
\keyword{datasets}
