;; 1. Based on: c1_f2_K_LIN2_linear
;; 2. Description: 1CMT+oral
;; x1. Author: tarjinde

$PROBLEM ...

;; 4. Date: 01.01.2011
;; 5. Version: 1
;; 6. Label:
;; Basic model
;; 7. Structural model:
;; One compartment model
;; 8. Covariate model:
;; No covariates
;; 9. Inter-individual variability:
;; CL and V1.
;; 10. Inter-occasion variability:
;; No IOV
;; 11. Residual variability:
;; Additive + Proportional
;; 12. Estimation:
;; IMP

$INPUT
ID AMT TIME DV WT LIN1 LIN2 LIN3 RND1 RND2 RND3 PW1 PW2 PW3 BN1
$DATA ../../../../../DerivedData/THEOPcov1.csv IGNORE=@
$SUB ADVAN2

$PK

;;; TVKLIN2-DEFINITION START
TVKLIN2= ( 1 + THETA(5)*(LIN2 - 3.04))
;;; TVKLIN2-DEFINITION END

;;; TVK-RELATION START
TVKCOV=TVKLIN2
;;; TVK-RELATION END

;;; TVKALIN1-DEFINITION START
TVKALIN1= ( 1 + THETA(4)*(LIN1 - 2.9))
;;; TVKALIN1-DEFINITION END

;;; TVKA-RELATION START
TVKACOV=TVKALIN1
;;; TVKA-RELATION END

TVKA=EXP(THETA(1))

TVKA = TVKACOV*TVKA
MU_1=LOG(TVKA)
KA = EXP(MU_1+ETA(1))

TVK=EXP(THETA(2))

TVK = TVKCOV*TVK
MU_2=LOG(TVK)
K = EXP(MU_2+ETA(2))

TVV=EXP(THETA(3))
MU_3=LOG(TVV)
V = EXP(MU_3+ETA(3))

CL = K*V

S2 = V

$ERROR

IPRED=F
W=SQRT(SIGMA(1,1)*IPRED**2 + SIGMA(2,2))  ; proportional + additive error
IRES=DV-IPRED
IWRES=IRES/W
Y=IPRED + IPRED*EPS(1) + EPS(2)


$THETA
0.30999    ; KA ; h-1 ; LOG
-2.4116    ; K ; h-1 ; LOG
-0.77523    ; V ; L ; LOG
$THETA    (-1,1.1702,5)  ; TVKALIN1linear
$THETA    (-1,0.84151,5)  ; TVKLIN2linear
$OMEGA
0.00015451			           ; IIV_KA ; LOG
0.0014194			           ; IIV_K ; LOG
0.019023			           ; IIV_V ; LOG

$SIGMA
0.01606    ; prop error
0.075707    ; add error

; ; Parameter estimation - FOCE
; ;$EST METHOD=1 INTER NOABORT MAXEVAL=9999 PRINT=1 NSIG=3 SIGL=9
; 
; ; Parameter estimation - IMP
; $EST METHOD=IMP ISAMPLE=300 NITER=300 RANMETHOD=3S2P
; CTYPE=3 CITER=10 CALPHA=0.05 CINTERVAL=3
; PRINT=1 NOABORT INTERACTION
; 
; ; Parameer estimation - SAEM
; ;$EST METHOD=SAEM ISAMPLE=2 NBURN=1000 NITER=500 RANMETHOD=3S2P
; ;CTYPE=3 CITER=10 CALPHA=0.05 CINTERVAL=10
; ;PRINT=1 NOABORT INTERACTION
; 
; ; Objective function and covariance evaluation
; $EST METHOD=IMP INTER EONLY= 1 MAPITER=0 ISAMPLE = 2000 NITER = 10 RANMETHOD=3S2P NOABORT PRINT=1 NSIG=3 SIGL=9
; 
; $COV MATRIX=R PRINT=E UNCONDITIONAL SIGL=10
; 
$SIM (12345) ONLYSIM SUBPR=10

$TABLE ID TIME IPRED IWRES IRES CWRES NPDE
FILE=sdtabm1s NOPRINT ONEHEADER
$TABLE ID ETAS(1:LAST); individual parameters
FILE=patabm1s NOPRINT ONEHEADER
$TABLE ID ; continuous covariates
FILE=cotabm1s NOPRINT ONEHEADER
$TABLE ID ; categorical covariates
FILE=catabm1s NOPRINT ONEHEADER
