% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partition_Map.R
\name{partition.map}
\alias{partition.map}
\title{Partition Map}
\usage{
partition.map(x, y, type = NULL, order = NULL, override = FALSE)
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{type}{Controls the partitioning basis.  Set to \code{type="XONLY"} for X-axis based partitioning.  Defaults to NULL for both X and Y-axis partitioning.}

\item{order}{Number of partial moment quadrants to be generated.}

\item{override}{Reduces minimum number of necessary observations in a quadrant to 1 when \code{override=TRUE}.}
}
\value{
Returns both a dataframe \code{"df"} of X and Y observations with their partition assignment in the 3d column; and the regression points \code{"regression.points"} for that given \code{order}.
}
\description{
Creates partitions based on quadrant means, assigning observations to those quadrants.  Needed for correlation, dependence, regression routines.  Default degree = 1 for area, but routines have their own conditional degree specifications built in
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
partition.map(x,y)
## Dataframe of observations and partitions
partition.map(x,y,order=1)$df
## Regression points
partition.map(x,y,order=1)$regression.points
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}

