% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{NNS.ANOVA}
\alias{NNS.ANOVA}
\title{NNS ANOVA}
\usage{
NNS.ANOVA(A, pairwise = FALSE)
}
\arguments{
\item{A}{Matrix of variables.}

\item{pairwise}{Returns pairwise certainty tests when set to \code{pairwise=TRUE}.  Defaults to \code{pairwise=FALSE}.}
}
\value{
Returns the degree certainty the samples belong to the same population [0,1].
}
\description{
Analysis of variance (ANOVA) based on lower partial moment CDFs for multiple variables.  Returns a degree of certainty the samples belong to the same population, not a p-value.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
A<-cbind(x,y)
NNS.ANOVA(A,pairwise=TRUE)
mean(na.omit(NNS.ANOVA(A,pairwise = TRUE)$x))
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{ANOVA}

