% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getData}
\alias{getData}
\title{Function to retrieve data from the monthly output file created by NUCOMBog}
\source{
The model can be sent upon request at jeroenpullens[at]gmail[dot]com
}
\usage{
getData(setup, startval)
}
\arguments{
\item{setup}{setup_structure described in setup_NUCOM}

\item{startval}{When a spinup is used for the model and not all output is necessary, this "startval" parameter can be used to cut the output off, i.e. the starting row from which the "outmo.txt" file is loaded. Default is 1.}
}
\description{
This function returns the data from the monthly output file created by NUCOMBog.

The original model provides net primary production (NPP) as an output, the model has been modified to provide autotrophic respiration aswell. In this way the net ecosystem exchange (NEE) can be calculated, since NEE = NPP - autotrophic respiration. The micrometeorological sign convention is used in this model, e.g. a negative value for NEE means carbon uptake. All fluxes are in gram carbon per square meter per month (gC m-2 month-1).
The model gives water table depth (WTD) in meters and positive values mean below ground level.

The possible outputs of the model are Net Primary Production (NPP), Net Ecosystem Exchange (NEE), heterotrohpic respiration (hetero_resp) and water table depth (WTD). The desired output needs to be specified in the setup_NUCOM function.

The getData function is integrated in all runnucom functions.
}
\examples{
\dontrun{
getData(setup=test_setup_singlecore,startval=1)
}
}
\author{
JWM Pullens
}

