% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{boss}
\alias{boss}
\title{Ideal boss survey}
\format{
A data frame with 73 rows (participants) and 39 columns (questions):
\itemize{
\item columns 1-30: statements about the ideal boss
\item columns 31-39: personal information
}
}
\source{
Florian LECLERE and Marianne ANDRE, students at l'Institut Agro Rennes-Angers
}
\usage{
boss
}
\description{
These data were collected after a Q-method-like survey on participants' perception of an "ideal boss".
Participants had to rank how much they agreed with 30 statements about an ideal boss; then, they were asked personal questions.
}
\examples{
\donttest{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(FactoMineR)
library(NaileR)
data(boss)
res_mca_boss <- MCA(boss, quali.sup = 31:39,
ncp = 30, level.ventil = 0.05, graph = FALSE)
res_hcpc_boss <- HCPC(res_mca_boss, nb.clust = 4, graph = FALSE)
don_clust_boss <- res_hcpc_boss$data.clust

intro_boss <- 'A study on "the ideal boss" was led on 73 participants.
The study had 2 parts. In the first part,
participants were given statements about the ideal boss
(starting with "My ideal boss...").
They had to rate, on a scale from 1 to 5,
how much they agreed with the statements;
1 being "Strongly disagree", 3 being "neutral"
and 5 being "Strongly agree".
In the second part, they were asked for personal information:
work experience, age, etc.
Participants were then split into groups based on their answers.'
intro_boss <- gsub('\n', ' ', intro_boss) |>
stringr::str_squish()

req_boss <- "Please describe, for each group, their ideal boss.
Then, give each group a new name, based on your conclusions."
req_boss <- gsub('\n', ' ', req_boss) |>
stringr::str_squish()


res_boss <- nail_catdes(don_clust_boss, num.var = 40,
introduction = intro_boss, request = req_boss,
isolate.groups = FALSE, drop.negative = TRUE)
res_boss$response |> cat()
}
}
\keyword{datasets}
