% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMDS.R, R/pcoa.R
\name{summary.NMDS}
\alias{summary.NMDS}
\alias{summary.PCoA}
\title{Summarize NMDS Results}
\usage{
\method{summary}{NMDS}(object, ...)

\method{summary}{PCoA}(object, ...)
}
\arguments{
\item{object}{An object of class "PCoA" produced by \code{\link{runPCoA}} function.}

\item{...}{Additional arguments (currently not used).}
}
\value{
A list containing:
\itemize{
\item stress - NMDS stress value
\item points - Sample coordinates in the reduced space
\item adonis2 - PERMANOVA results (R2, p-value, significance)
\item anosim - ANOSIM results (R statistic, p-value, significance)
}

A list containing:
\itemize{
\item points - Sample coordinates in the reduced space.
\item eig - Variance explained by each principal coordinate axis.
\item adonis2 - PERMANOVA results (R2, p-value, significance)
\item anosim - ANOSIM results (R statistic, p-value, significance)
}
}
\description{
Provides a concise summary of Non-Metric Multidimensional Scaling (NMDS) analysis results,
including stress value, PERMANOVA (adonis2) and ANOSIM test statistics.

Provides a concise summary of Principal Coordinates Analysis (PCoA) analysis results,
including PERMANOVA (adonis2) and ANOSIM test statistics.
}
\examples{
# Example with default Bray-Curtis distance
data <- data.frame(
  Cephalobus = c(10, 20, 30, 1, 6, 5),
  Eucephalobus = c(5, 10, 12, 30, 1, 6),
  Acrobeloides = c(1, 2, 3, 12, 30, 1),
  Caenorhabditis = c(5, 8, 15, 2, 3, 12),
  Aphelenchus = c(5, 13, 11, 15, 2, 3),
  Leptonchus = c(3, 10, 15, 0, 15, 11),
  Pratylenchus = c(9, 2, 15, 15, 0, 15),
  Tylenchus = c(5, 0, 15, 11, 15, 2),
  Mesodorylaimus = c(7, 10, 18, 3, 12, 30),
  Discolaimus = c(1, 10, 25, 10, 18, 3),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)
group_df <- data.frame(
  group = c("A", "A", "B", "B", "C", "C"),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)

# Example for summary.NMDS
nmds <- runNMDS(data, group = group_df)
summary(nmds)

# Example for summary.PCoA
pcoa <- runPCoA(data, group = group_df)
summary(pcoa)

}
