% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{oneOf}
\alias{oneOf}
\alias{oneOf,matrix-method}
\title{One random \code{agent}}
\usage{
oneOf(agents)

\S4method{oneOf}{matrix}(agents)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              Matrix (\code{ncol} = 3) with the first column "\code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates and the
              third column \code{id}, or

              \code{AgentMatrix} object representing the moving \code{agents}, or

              Matrix (\code{ncol} = 2) with the first column \code{whoTurtles} and the
              second column \code{id}.}
}
\value{
Matrix (\code{ncol} = 2, \code{nrow} = 1) with the first column \code{pxcor}
        and the second  column \code{pycor} representing the coordinates of the
        selected \code{patch} from \code{agents}, or

        Matrix (\code{ncol} = 2) with the first column \code{pxcor}
        and the second  column \code{pycor} representing the coordinates of the
        selected \code{patches} from \code{agents}, one per individual \code{id}, or

        \code{AgentMatrix} object representing the \code{turtle}
        selected from \code{agents}, or

        Integer. Vector of \code{who} numbers for the selected \code{turtles} from
        \code{agents}, one per individual \code{id}.
}
\description{
Report one \code{patch} or \code{turtle} randomly selected among \code{agents}.
}
\details{
If \code{agents} is a matrix with \code{ncol} = 3, the selection of one
         random \code{patch} is done per individual \code{id}. The order of the \code{patches}
         coordinates returned follow the order of \code{id}.
         If \code{agents} is a matrix (\code{ncol} = 2) with columns \code{whoTurtles} and
         \code{id}, the selection of one random \code{turtle} (defined by their \code{whoTurtles})
         is done per individual \code{id}. The order of the \code{who} numbers returned
         follow the order of \code{id}.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
pSelect <- oneOf(agents = patches(w1))

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
tSelect <- oneOf(agents = t1)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#one-of}
}
\author{
Sarah Bauduin
}
